<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Mail\PasswordUpdateMail;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;

class SettingsController extends Controller
{
    public function change_password()
    {
        return view("frontend.settings.change_password");
    }

    public function password(Request $request)
    {
        $this->validate($request,[
            'old_password' => 'required',
            'new_password' => 'required|confirmed',
        ]);

        try {
            # Match The Old Password
            if(!Hash::check($request->old_password, auth()->user()->password)){
                return redirect()->back()->with("error", "Old Password Doesn't match!");
            }

            # Update the new Password
            User::whereId(auth()->user()->id)->update([
                'password' => Hash::make($request->new_password)
            ]);

            Mail::to(Auth::user()->email)->send(new PasswordUpdateMail(Auth::user()->name));
            return back()->with("success", "Password changed successfully!");
        }catch (\Exception $exception){
            return redirect()->back()->with("error",$exception->getMessage());
        }

    }

    public function destroy(Request $request)
    {
        Auth::guard('web')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('/');
    }
}
