<?php

namespace App\Http\Controllers;

use App\Http\Requests\LoginRequest;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    public function check_login(LoginRequest $request)
    {
        $check= User::where('email',$request->email)->whereIn('role',['team','writer','vendor'])->where('status',0)->first();
        if( $check ){
            return redirect()->back()->with("error","You account is blocked. Contact Administrator @ admin@example.com");
        }

        $request->authenticate();

        $request->session()->regenerate();

        $u= Auth::user();
        $u->last_login = $u->current_login;
        $u->current_login = Carbon::now();
        $u->login_count = ($u->login_count ?? 0 ) + 1;
        $u->save();

        if( \auth()->user()->role == 'vendor' ){
            return redirect()->intended(route("vendor.dashboard"));
        }



    }
}
