<?php


namespace App\Harman\Vendor;


use App\Harman\Common\OrderDetailStatus;
use App\Models\OrderDetail;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class VendorTasksInProcessQuery
{
    public static function get()
    {
        return OrderDetail::whereHas("site",function ($query){
            $query->where('user_id',Auth::id());
        })->with(["order",
            "site" => function($query){
                $query->addSelect(["domain_type"=> DB::table("masters")->select("name")->whereColumn('masters.id',"domain_type_id")->limit(1) ]);
            },
            "site.user",
            "site.site_multiple_category_type","site.site_multiple_traffic_source","site.site_multiple_grey_niche"])
            ->where('status','!=',OrderDetailStatus::$PENDING)
            ->where('status','!=',OrderDetailStatus::$PROJECT_COMPLETED)
            ->get();
    }
}
