<?php


namespace App\Harman\Vendor\Site;


use App\Harman\Common\SiteStatus;
use App\Models\Site;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CreateSiteStep1
{
    public function create(Request $request)
    {
        try {
            $check= Site::where('unique_code',$request->id)->first();
            if( $check ){
                $site= $check;
            }else{
                $site= new Site();
            }


            $site->unique_code = $request->id;
            $site->step1 = 1;
            $site->source = "from_vendor";
            $site->status = SiteStatus::$INCOMPLETE;
            $site->steps_complete = 1;
            $site->created_user_id= Auth::id();
            $site->user_id= Auth::id();
            $site->save();

            session()->put("code",$request->id);

            return redirect()->route("vendor.site_create",["type"=>"step2"]);
        }catch (\Exception $exception){
            return redirect()->back()->with("error",$exception->getMessage());
        }
    }
}
