<?php


namespace App\Harman\Site;


use App\Models\Site;
use App\Models\SiteMultiple;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CreateSiteStep3
{
    public function create(Request $request)
    {
        if( $request->grey_niche_type == 9 ){
            if( empty($request->grey_niche) ){
                return redirect()->back()->withInput()->withErrors(['grey_niche'=>"Grey Niche Required"]);
            }
        }


        try {
            DB::beginTransaction();
            $site= Site::with("site_multiple_category_type","site_multiple_traffic_source","site_multiple_grey_niche")->where('unique_code',$request->id)->firstOrFail();

            $site->sponsor_type_id= $request->sponsor_type;
            $site->link_type_id= $request->link_type;
            $site->validity_type_id= $request->validity_type;
            $site->grey_niche_type_id= $request->grey_niche_type;
            $site->no_of_links_id= $request->no_of_links;
            $site->steps_complete = 3;
            $site->step3= 1;
            $site->save();

            if( $site->grey_niche_type_id == "9" ) {
                foreach ($site->site_multiple_grey_niche as $item){
                    $item->delete();
                }
                foreach ($request->grey_niche as $grey) {
                    $multiple = new SiteMultiple();
                    $multiple->site_id = $site->id;
                    $multiple->name = $grey;
                    $multiple->master_type_url_slug = 'grey-niche';
                    $multiple->save();
                }
            }

            DB::commit();

            return redirect()->route("site_create",["type"=>"step4"]);
        }catch (\Exception $exception){
            DB::rollBack();
            return redirect()->back()->with("error",$exception->getMessage());
        }


    }
}
