<?php


namespace App\Harman\Site;


use App\Harman\Common\SiteStatus;
use App\Models\Site;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

class CreateSiteStep1
{
    use ValidatesRequests;

    public function create(Request $request)
    {
         try {
             $check= Site::where('unique_code',$request->id)->first();
             if( $check ){
                 $site= $check;
             }else{
                 $site= new Site();
             }

             $site->name= $request->name;
             $site->email= $request->email;
             $site->unique_code = $request->id;
             $site->step1 = 1;
             if( $request->utm_source == 'from_email' ){
                 $site->source = "from_email";
             }else{
                 $site->source = "from_site";
             }
             $site->status = SiteStatus::$INCOMPLETE;
             $site->steps_complete = 1;
             $site->save();

             session()->put("code",$request->id);

             return redirect()->route("site_create",["type"=>"step2"]);
         }catch (\Exception $exception){
             return redirect()->back()->with("error",$exception->getMessage());
         }
    }
}
