<?php

namespace App\Harman\Helpers;
class LinkVerify
{
    private $target_url = "";
    private $anchor_keywords ="";
    private $page_url = "";

    public function __construct($target_url, $anchor_keywords, $page_url)
    {
        $this->target_url = $target_url;
        $this->anchor_keywords = $anchor_keywords;
        $this->page_url = $page_url;
    }

    public function verify()
    {
        $html = file_get_html($this->page_url);
        $links = $html->find('a');
        foreach ($links as $link) {
         
            if( ( trim(strtolower($link->plaintext)) == strtolower($this->anchor_keywords) ) && ( rtrim(strtolower($link->href),'/') == rtrim(strtolower($this->target_url),'/'))){
                return true;
            }

        }
        return false;
    }

}
