<?php


namespace App\Harman\Helpers;


use Illuminate\Support\Str;

class FileUpload
{
    private $file;
    private $request;
    private $path;
    private string $prefix;

    public function __construct($request,$file,$path,$prefix = ''){
        $this->file = $file;
        $this->request = $request;
        $this->path = public_path()."/uploads";
        $this->prefix = $prefix;
    }

    private function random(){
        return $this->prefix.Str::random(30). time () ;
    }

    public function filename(){
        return $this->random().'.'.$this->request->file($this->file)->getClientOriginalExtension();
    }

    public function upload(){

        $file=$this->request->file($this->file);
        $filename= $this->filename();
        if( isset( $file ) ){
            if($this->request->file($this->file)->move($this->path,$filename)){
                return $filename;
            }else{
                throw new \Exception("Error");
            }
            return false;
        }

        return false;
    }
}
