<?php


namespace App\Harman\Helpers;


use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class FileProcess
{
    private $path;
    private $input_filename;
    private $prefix="";
    private $tablename = null;
    private $field_name = null;

    public function init($path,$input_filename)
    {
        $this->path= $path;
        $this->input_filename= $input_filename;
        return $this;
    }

    public function unique($tablename, $field_name)
    {
        $this->tablename= $tablename;
        $this->field_name= $field_name;
        return $this;
    }

    public function prefix($prefix)
    {
        $this->prefix = $prefix;
    }

    /*
     * Generate a random string
     */
    private function random()
    {
        return $this->prefix . Str::random(50) .'-'.time();
    }




    /*
     * return new filename
     */
    private function filename()
    {
        $filename= $this->random().'.'.$this->input_filename->getClientOriginalExtension();

        if( $this->tablename == null ){
            return $filename;
        }else {
            $count = DB::table($this->tablename)->where($this->field_name, $filename)->count();
            if ($count == 0) {
                return $filename;
            } else {
                return $this->filename();
            }
        }
    }

    public function upload()
    {
        $file= $this->input_filename;
        $filename= $this->filename();

        if( $file->storeAs($this->path,$filename) ){
            return $filename;
        }else{
            throw new \Exception("Server Error");
        }
    }
}
