<?php


namespace App\Harman\Helpers;


use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class FileMultipleProcess
{
    private $path;
    private $request;
    private $input_filename;
    private $prefix="";
    private $tablename = null;
    private $field_name = null;

    public function init($path,$input_filename,$request)
    {
        $this->path = $path;
        $this->input_filename= $input_filename;
        $this->request= $request;
        return $this;
    }

    public function unique($tablename, $field_name)
    {
        $this->tablename= $tablename;
        $this->field_name= $field_name;
        return $this;
    }

    public function prefix($prefix)
    {
        $this->prefix = $prefix;
    }

    /*
   * Generate a random string
   */
    private function random()
    {
        return $this->prefix . Str::random(50).'-'.time();
    }

    /*
    * return new filename
    */
    private function filename($file)
    {
        $filename= $this->random().'.'.$file->getClientOriginalExtension();

        if( $this->tablename == null ){
            return $filename;
        }else {
            $count = DB::table($this->tablename)->where($this->field_name, $filename)->count();
            if ($count == 0) {
                return $filename;
            } else {
                return $this->filename($file);
            }
        }
    }

    public function upload()
    {
        $filenames= [];
        foreach ($this->request->file($this->input_filename) as $value ){
            $filename= $this->filename($value);

            if( $value->storeAs($this->path,$filename) ){
                $filenames[] = $filename;
            }else{
                throw new \Exception("Server Error");
            }

        }

        return $filenames;
    }

}
