<?php

namespace App\Filament\Writer\Widgets;

use App\Filament\Writer\Resources\OrderAddedNotificationResource;
use App\Models\NewOrder;
use App\Project\NewOrderStatus;
use Carbon\Carbon;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Support\Facades\Auth;

class OrderAddedTodayNotificationWidget extends BaseWidget
{
    protected int | string | array $columnSpan = 2;

    protected static bool $isDiscovered = false;

    public function table(Table $table): Table
    {
        return $table
            ->query(
                NewOrder::whereHas("order_processes_manager_pushed_to_writer", function ($q){
                    $q->where('writer_id',Auth::id())->whereDate('created_at',Carbon::today());
                })->has("order_processes_manager_pushed_to_writer.new_order_process_details")
                    ->where('new_order_status',NewOrderStatus::$MANAGER_PUSHED_TO_WRITER)
                    ->with("order_processes_manager_pushed_to_writer","manager")

            )
            ->columns([
                Tables\Columns\TextColumn::make("order_id"),
                Tables\Columns\TextColumn::make("order_type")->sortable(),
                Tables\Columns\TextColumn::make("manager.name")->sortable(),
                Tables\Columns\TextColumn::make("id")->label("Pushed Date")->formatStateUsing(function (NewOrder $order) {
                    return Carbon::parse($order->order_processes_manager_pushed_to_writer->created_at)->toDayDateTimeString();
                }),
            ])  ->actions([
                Tables\Actions\Action::make('Detail')
                    ->label(" ")
                    ->icon("heroicon-o-eye")
                    ->tooltip("Detail")
                    ->label("Push To Manager")->url(function (NewOrder $record) {
                    return OrderAddedNotificationResource::getUrl('detail', ['record' => $record->id]);
                })
            ]);
    }
}
