<?php

namespace App\Filament\Writer\Resources\TicketResource\Pages;

use App\Filament\Writer\Resources\TicketResource;
use App\Models\Message;
use App\Models\Thread;
use App\Models\User;
use Carbon\Carbon;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Infolists\Components\RepeatableEntry;
use Filament\Infolists\Components\Section;
use Filament\Infolists\Components\TextEntry;
use Filament\Infolists\Concerns\InteractsWithInfolists;
use Filament\Infolists\Contracts\HasInfolists;
use Filament\Infolists\Infolist;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\Page;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\HtmlString;

class ThreadDetails extends Page implements HasForms, HasInfolists
{
    use InteractsWithInfolists;
    use InteractsWithForms;
    public $record;
    public ?array $data = [];

    protected static string $resource = TicketResource::class;

    protected static string $view = 'filament.writer.resources.ticket-resource.pages.thread-details';

    public function mount(int | string $record): void
    {
        $this->form->fill([]);

    }

    public function form(Form $form): Form
    {
        return $form

            ->schema([
                \Filament\Forms\Components\Section::make("Write a Reply")->schema([
                    \Filament\Forms\Components\Textarea::make("message")->placeholder("Enter Message")->required(),
                ])
            ])->statePath('data');
    }

        public function threadInfolist(Infolist $infolist): Infolist
    {
        $thread= Thread::with(['messages' => function ($query) {
            $query->orderBy('id', 'desc');
        }])->where(function ($query){
            $query->where('user_id',Auth::id())->orWhere('owner_id',Auth::id());
        })->where('id',$this->record)->firstOrFail();


        return $infolist
                ->record($thread)
                ->schema([
                    Section::make(function ($record){
                        return $record->owner->name . ' (' . $record->owner->role .')' ;
                    })->description(function ($record){
                        return Carbon::parse($record->created_at)->diffForHumans();
                    })

                        ->schema([
                            TextEntry::make("subject"),



                        ]),
                    TextEntry::make("id")->label(" ")->formatStateUsing(function ($record){
                        return new HtmlString('<span style="font-size: 25px;font-weight: bold;color: red;">'.count($record->messages). ' Replies</span>');
                    }),

                    RepeatableEntry::make("messages")->schema([
                        Section::make(function ($record){
                            return $record->user->name . '(' .$record->user->role .')';
                        })->description(function ($record){
                            return Carbon::parse($record->created_at)->diffForHumans();
                        })->schema([
                            TextEntry::make("message")->inlineLabel()
                        ])
                    ])



                ]);
    }

    public function create(): void
    {
        $data = $this->form->getState();

        try{

            DB::beginTransaction();
            $message= new Message();
            $message->thread_id= $this->record;
            $message->user_id= Auth::id();
            $message->message= $data['message'];
            $message->save();

            $thread= Thread::findOrFail($this->record);
            $thread->updated_at= now();
            $thread->save();

            DB::commit();
            Notification::make("success")->title("Message Sent Successfully")->send();

            $user_id = User::find($thread->user_id);
            $owner_id = User::find($thread->owner_id);


            Notification::make()->title("New Message in Thread")
                ->body("Pushed by ".Auth::user()->name.'('.Auth::user()->email.')')
                ->success()
                ->sendToDatabase([$user_id,$owner_id]);


            $this->form->fill();
        }catch (\Exception $exception){
            DB::rollBack();
            session()->flash("error",$exception->getMessage());
        }


    }

}
