<?php

namespace App\Filament\Writer\Resources\CompletedOrdersResource\Pages;

use App\Filament\Writer\Resources\CompletedOrdersResource;
use App\Models\NewOrder;
use Filament\Infolists\Infolist;
use Filament\Resources\Pages\Page;
use Illuminate\Contracts\View\View;
use JaOcero\ActivityTimeline\Components\ActivityDate;
use JaOcero\ActivityTimeline\Components\ActivityDescription;
use JaOcero\ActivityTimeline\Components\ActivityIcon;
use JaOcero\ActivityTimeline\Components\ActivitySection;
use JaOcero\ActivityTimeline\Components\ActivityTitle;
use JaOcero\ActivityTimeline\Pages\ActivityTimelinePage;

class OrderDetailPage extends Page
{
    public $record;
    protected static string $resource = CompletedOrdersResource::class;

    protected static string $view = 'filament.writer.resources.completed-orders-resource.pages.order-detail-page';

    public function render(): View
    {
        $order= NewOrder::with("new_order_processes.new_order_process_details")->where('id',$this->record)->first();
        return parent::render()->with("order",$order);
    }


}
