<?php

namespace App\Filament\Widgets;

use App\Models\WithdrawRequest;
use Filament\Widgets\ChartWidget;
use Illuminate\Support\Facades\DB;

class YearlyPaymentChart extends ChartWidget
{
    protected static ?string $heading = 'Monthly Payment';

    protected static bool $isDiscovered = false;
    public ?string $filter = '2024';
    protected static ?string $pollingInterval = null;

    public function total_amount($month,$year)
    {
        return WithdrawRequest::whereHas("wallet_histories",function ($q) use ($month,$year){
            return $q->whereRaw('MONTH(approved_date) = '.$month.' AND YEAR(approved_date) = '.$year);
        })->withSum(['wallet_histories as total_price' => function ($query) use ($month,$year){
            $query->select(DB::raw('SUM(price)'))->whereRaw('MONTH(approved_date) = '.$month.' AND YEAR(approved_date) = '.$year);
        }], 'price')
            ->where('status', 1)
            ->get()->sum("total_price");
    }

    protected function getFilters(): ?array
    {
        return [
            2023 => 2023,
            2024 => 2024,
            2025 => 2025,
            2026 => 2026,
            2027 => 2027,
        ];
    }

    protected function getData(): array
    {
        $year =  $this->filter;;
        $months = [];
        foreach (range(1,12) as $item){
            $months[] = $this->total_amount($item,$year);
        }

        return [
            'datasets' => [
                [
                    'label' => 'Payment',
                    'data' => $months,
                    'borderColor'    => '#1d4ed8',
                    'backgroundColor'=> '#1d4ed8',
                ]
            ],
            'labels' => ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
        ];
    }

    protected function getType(): string
    {
        return 'bar';
    }
}
