<?php

namespace App\Filament\Widgets;

use App\Models\User;
use Filament\Widgets\ChartWidget;

class WriterLoginChart extends ChartWidget
{
    protected static ?string $heading = 'Writer Login Info';
    protected static string $color = 'info';

    protected static bool $isDiscovered = false;
    protected static ?string $pollingInterval = null;

    protected function getData(): array
    {
        $users_team= User::select("email","login_count")->where('role','writer')->get();

        return [
            'datasets' => [
                [
                    'label' => 'Team Logins',
                    'data' => $users_team->pluck('login_count')->map(function ($u){
                        return $u ?? 0;
                    })->toArray(),
                ],
            ],
            'labels' => $users_team->pluck('email')->toArray(),
        ];
    }

    protected function getType(): string
    {
        return 'bar';
    }
}
