<?php

namespace App\Filament\Widgets;

use App\Filament\Pages\PaymentHistoryDetail;
use App\Models\WithdrawRequest;
use Carbon\Carbon;
use Filament\Tables;
use Filament\Tables\Actions\Action;
use Filament\Tables\Columns\Summarizers\Sum;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\HtmlString;

class PendingWithdrawalRequestsWidgets extends BaseWidget
{
    protected static bool $isDiscovered  = false;
    protected int | string | array $columnSpan = 2;
    public function table(Table $table): Table
    {
        return $table
            ->defaultSort("created_at", "desc")
            ->query(
                WithdrawRequest::has("wallet_histories")->withSum(['wallet_histories as total_price' => function ($query) {
                    $query->select(DB::raw('SUM(price)'));
                }], 'price')->where('status',0)
            )
            ->columns([

                TextColumn::make('user.name')->description(function (WithdrawRequest $record) {
                    return $record->user->email;
                })->wrap(),
                TextColumn::make("created_at")->label("Payment Method")
                    ->wrap()
                    ->description(function (WithdrawRequest $record) {
                        if( $record->wallet_histories[0]->payment_method  == 'bank' ){
                            return new HtmlString('
                                <strong>Bank Type:- </strong>'.$record->wallet_histories[0]->bank_type.' <br>
                                <strong>Beneficiary Account Number:- </strong>'.$record->wallet_histories[0]->beneficiary_account_number.' <br>
                                <strong>Beneficiary Name:- </strong>'.$record->wallet_histories[0]->beneficiary_name.' <br>
                                <strong>Customer Reference Number:- </strong>'.$record->wallet_histories[0]->customer_reference_number.' <br>
                                <strong>Beneficiary Bank Name:- </strong>'.$record->wallet_histories[0]->bene_bank_name.' <br>
                                <strong>Beneficiary Bank Branch Name:- </strong>'.$record->wallet_histories[0]->bene_bank_branch_name.' <br>
                                <strong>IFSC Code:- </strong>'.$record->wallet_histories[0]->ifsc_code.' <br>
                                <strong>Beneficiary Email id:- </strong>'.$record->wallet_histories[0]->beneficiary_email_id .' <br>'

                            );
                        }


                        if($record->wallet_histories[0]->payment_method == "qr_code") {
                            return new HtmlString('<div class="flex items-center flex-col justify-between border-b border-gray-200 mt-2 pb-1 mb-1" >

                                    <span class="text-black font-bold" >
                                    <a href = "/uploads/'.$record->wallet_histories[0]->qr_code_image .'" target = "_blank" >
                                        <img src = "/uploads/'.$record->wallet_histories[0]->qr_code_image .'" class="w-32" >
                                    </a >
                                    </span >
                                </div >');
                        }

                        if($record->wallet_histories[0]->payment_method == "paypal_id") {
                            return $record->wallet_histories[0]->paypal_email;

                        }

                        if($record->wallet_histories[0]->payment_method == "upi_id") {
                            return $record->wallet_histories[0]->upi_id;

                        }

                    })
                    ->badge()
                    ->color(function (WithdrawRequest $record) {
                        if( $record->wallet_histories[0]->payment_method  == 'bank' ){
                            return 'success';
                        }


                        if($record->wallet_histories[0]->payment_method == "qr_code") {
                            return 'danger';
                        }

                        if($record->wallet_histories[0]->payment_method == "paypal_id") {
                            return 'info';

                        }

                        if($record->wallet_histories[0]->payment_method == "upi_id") {
                            return 'warning';

                        }

                    })
                    ->formatStateUsing(function (WithdrawRequest $record) {

                        if( $record->wallet_histories[0]->payment_method  == 'bank' ){
                            return 'Bank Details';
                        }


                        if($record->wallet_histories[0]->payment_method == "qr_code") {
                            return 'QR Code';
                        }

                        if($record->wallet_histories[0]->payment_method == "paypal_id") {
                            return 'Paypal ID';

                        }

                        if($record->wallet_histories[0]->payment_method == "upi_id") {
                            return 'UPI ID';

                        }



                    }),
                TextColumn::make("total_price")->label("Amount")->summarize(Sum::make())->sortable(),

                TextColumn::make("updated_at")->label("Datetime")->formatStateUsing(function (WithdrawRequest $record) {
                    return new HtmlString(' <div class="flex items-center">
                                <div style="font-weight: bold;font-size: 12px;">Request Date :- </div>
                                <div style="font-size: 12px;">'.Carbon::parse($record->wallet_histories[0]->request_date)->toDayDateTimeString() .'</div>
                            </div>
                             <div class="flex items-center">
                                <div style="font-weight: bold;font-size: 12px;">Clearance Date :-</div>
                                <div style="font-size: 12px;">'.Carbon::parse($record->wallet_histories[0]->approved_date)->toDayDateTimeString().'</div>
                            </div>
                            <div class="flex items-center">
                                <div style="font-weight: bold;font-size: 12px;">Remarks:- </div>
                                <div style="font-size: 12px;">'.$record->wallet_histories[0]->remarks.'</div>
                            </div>


                            </div>
');
                }),

            ])
            ->actions([
                Action::make("detail")->modalContent(function (WithdrawRequest $record) {
                    return view("welcome")->with("record", $record->id)->with("action", "new");
                })->modalSubmitAction(false)->modalCancelAction(false)
            ]);
    }
}
