<?php

namespace App\Filament\Widgets;

use App\Models\OrdersView;
use App\Project\NewOrderStatus;
use Filament\Widgets\ChartWidget;

class OrdersViewChart extends ChartWidget
{
    protected static ?string $heading = 'Orders Chart';

    protected static bool $isDiscovered = false;

    protected function getData(): array
    {
        $total = OrdersView::selectRaw("count(id) as total")->first();
        $pending=  OrdersView::selectRaw("count(id) as total")
            ->whereIn('new_order_status',[NewOrderStatus::$PENDING_ORDER,NewOrderStatus::$MANAGER_CREATED_ORDER_AND_PUSHED_TO_TEAM])
            ->first();

        $completed =   OrdersView::selectRaw("count(id) as total")
            ->whereRaw(' total = total1 and total != 0 and total1 !=0 and total != 0 ')
            ->first();

        $in_process= $total->total -  ( $pending->total + $completed->total );
        return [
            'datasets' => [
                [
                    'label' => 'Orders',
                    'data' => [$pending->total,$in_process,$completed->total],
                    'backgroundColor'=> ['#b91c1c','#a16207','#15803d'],
                    'borderWidth' => 0

                ],

            ],
            'labels' => ['Pending','In Process','Completed'],
        ];
    }

    protected function getType(): string
    {
        return 'bar';
    }
}
