<?php

namespace App\Filament\Widgets;

use App\Models\User;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class MembersOverview extends BaseWidget
{
    protected static bool $isDiscovered = false;

    protected static ?string $pollingInterval = null;

    protected function getStats(): array
    {
        $bloggers= User::selectRaw("count(*) as count")->where('role', 'vendor')->first();
        $managers = User::selectRaw("count(*) as count")->where('role', 'manager')->first();
        $teams = User::selectRaw("count(*) as count")->where('role', 'team')->first();
        $writers = User::selectRaw("count(*) as count")->where('role', 'writer')->first();
        return [
            Stat::make("Bloggers", $bloggers->count),
            Stat::make("Managers", $managers->count),
            Stat::make("Teams", $teams->count),
            Stat::make("Writers", $writers->count),
        ];
    }
}
