<?php

namespace App\Filament\Team\Widgets;

use App\Models\NewOrder;
use App\Project\NewOrderStatus;
use Carbon\Carbon;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\HtmlString;

class TodayRejectedLinksNotificationWidget extends BaseWidget
{
    protected static bool $isDiscovered = false;
    protected int | string | array $columnSpan = 2;

    public function table(Table $table): Table
    {
        return $table
            ->query(
                NewOrder::with("order_processes_manager_rejected_and_pushed_to_team.new_order_process_details.new_site")
                    ->whereHas("order_processes_manager_rejected_and_pushed_to_team",function ($query){
                        return $query->whereDate('created_at',Carbon::today());
                    })
                    ->where('new_order_status',NewOrderStatus::$MANAGER_DISAPPROVED_POST_TEAM)
                    ->where('team_id',Auth::id())
            )
            ->columns([
                Tables\Columns\TextColumn::make('order_id')->label("Order Id"),
                Tables\Columns\TextColumn::make('order_type')->label("Order Type"),
                Tables\Columns\TextColumn::make('no_of_links')->label("No of Links"),


                Tables\Columns\TextColumn::make('id')->label("Sites Sent")->formatStateUsing(function (NewOrder $order) {
                    $text = '';
                    foreach ($order->order_processes_manager_rejected_and_pushed_to_team->new_order_process_details as $detail) {
                        $text .= '<div style="margin-bottom: 10px;border-bottom: 1px solid #CCCCCC;padding-bottom: 10px;">
                                <div>'.$detail->new_site->root_domain.'</div>
                                <div>Note:- '.$detail->new_note .'</div>
                                <div>Post Url:- '.$detail->url.'</div>
                                </div>

                               ';
                    }
                    return new HtmlString($text);
                }),
                Tables\Columns\TextColumn::make('order_processes_manager_rejected_and_pushed_to_team.note')->label("Reason/Note"),
                Tables\Columns\TextColumn::make('client_website')->label("Client Website"),


                Tables\Columns\TextColumn::make('order_package')->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('message')->html()->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('order_processes_manager_rejected_and_pushed_to_team.created_at')->label("Pushed Date")->toggleable(isToggledHiddenByDefault: true),
            ]);
    }
}
