<?php

namespace App\Filament\Team\Widgets;

use App\Models\NewOrder;
use App\Project\NewOrderStatus;
use Carbon\Carbon;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Support\Facades\Auth;

class TodayOrderAddedNotificationWidget extends BaseWidget
{
    protected static bool $isDiscovered = false;
    protected int | string | array $columnSpan = 2;
    public function table(Table $table): Table
    {
        return $table
            ->query(
                NewOrder::where('team_id',Auth::id())
                    ->where('new_order_status',NewOrderStatus::$MANAGER_CREATED_ORDER_AND_PUSHED_TO_TEAM)
                    ->whereDate('created_at',Carbon::today())
            )
            ->recordUrl(null)
            ->columns([
                Tables\Columns\TextColumn::make('order_id')->label("Order Id"),
                Tables\Columns\TextColumn::make('order_type')->sortable()->label("Order Type"),
                Tables\Columns\TextColumn::make('category')->badge(),
                Tables\Columns\TextColumn::make('client_name')->label("Client Name"),
                Tables\Columns\TextColumn::make('client_website')->label("Client Website"),
                Tables\Columns\TextColumn::make('no_of_links')->sortable()->label("No of Links"),
                Tables\Columns\TextColumn::make('order_package')->label("Order Package"),
            ]);
    }
}
