<?php

namespace App\Filament\Team\Resources;

use App\Filament\Team\Resources\RejectedLinksResource\Pages;
use App\Filament\Team\Resources\RejectedLinksResource\RelationManagers;
use App\Models\NewOrder;
use App\Models\RejectedLinks;
use App\Project\NewOrderStatus;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\HtmlString;

class RejectedLinksResource extends Resource
{
    protected static ?string $model = NewOrder::class;
    protected static ?string $label = "Rejected Links";

    protected static ?string $navigationIcon = 'heroicon-o-no-symbol';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function getNavigationBadge(): ?string
    {
        return team_rejected_links();
    }

    public static function table(Table $table): Table
    {
        return $table
            ->striped()
            ->query(
                NewOrder::with("order_processes_manager_rejected_and_pushed_to_team.new_order_process_details.new_site")
                    ->where('new_order_status',NewOrderStatus::$MANAGER_DISAPPROVED_POST_TEAM)
                    ->where('team_id',Auth::id())

            )
            ->recordUrl(null)

            ->columns([
                Tables\Columns\TextColumn::make('order_id')->label("Order Id"),
                Tables\Columns\TextColumn::make('order_type')->label("Order Type"),
                Tables\Columns\TextColumn::make('no_of_links')->toggleable()->label("No of Links"),


                Tables\Columns\TextColumn::make('id')->label("Sites Sent")->toggleable()->formatStateUsing(function (NewOrder $order) {
                    $text = '';
                    foreach ($order->order_processes_manager_rejected_and_pushed_to_team->new_order_process_details as $detail) {
                        $text .= '<div style="margin-bottom: 10px;border-bottom: 1px solid #CCCCCC;padding-bottom: 10px;">
                                <div>'.$detail->new_site->root_domain.'</div>
                                <div>Note:- '.$detail->new_note .'</div>
                                <div>Post Url:- '.$detail->url.'</div>
                                </div>

                               ';
                    }
                    return new HtmlString($text);
                }),
                Tables\Columns\TextColumn::make('order_processes_manager_rejected_and_pushed_to_team.note')->toggleable()->label("Reason/Note"),
                Tables\Columns\TextColumn::make('client_website')->toggleable()->label("Client Website"),


                Tables\Columns\TextColumn::make('order_package')->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('message')->html()->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('order_processes_manager_rejected_and_pushed_to_team.created_at')->label("Pushed Date")->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\Action::make('push_to_manager')->icon("heroicon-o-arrow-top-right-on-square")->label(" ")->tooltip("Push To Manager")->url(function (NewOrder $record) {
                    return OrderAddedNotificationsResource::getUrl('push_to_manager', ['record' => $record->id]);
                })
//                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([

            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListRejectedLinks::route('/'),
            'create' => Pages\CreateRejectedLinks::route('/create'),
            'edit' => Pages\EditRejectedLinks::route('/{record}/edit'),
        ];
    }
}
