<?php

namespace App\Filament\Resources;

use App\Filament\Resources\PriceChartResource\Pages;
use App\Filament\Resources\PriceChartResource\RelationManagers;
use App\Models\PriceChart;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class PriceChartResource extends Resource
{
    protected static ?string $model = PriceChart::class;

    protected static ?string $navigationIcon = 'heroicon-o-chart-bar';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->recordUrl(null)
            ->columns([
                Tables\Columns\TextColumn::make("rd_start_range")
                    ->label("RD")
                    ->formatStateUsing(function (PriceChart $price) {
                        return  $price->rd_start_range . ( ( $price->rd_start_range == $price->rd_end_range) ? "+" : "-".$price->rd_end_range );
                    }),
                Tables\Columns\TextColumn::make("traffic_start_range")
                    ->label("Traffic")
                    ->formatStateUsing(function (PriceChart $price) {
                        return  $price->traffic_start_range . ( ( $price->traffic_start_range == $price->traffic_end_range ) ? "+" : "-".$price->traffic_end_range );
                    }),
                Tables\Columns\TextColumn::make("dr_start_range")
                    ->label("DR")
                    ->formatStateUsing(function (PriceChart $price) {
                        return  $price->dr_start_range . ( ( $price->dr_start_range == $price->dr_end_range ) ? "+" : "-".$price->dr_end_range );
                    }),
                Tables\Columns\TextColumn::make("da_start_range")
                    ->label("DA")
                    ->formatStateUsing(function (PriceChart $price) {
                        return  $price->da_start_range . ( ( $price->da_start_range == $price->da_end_range ) ? "+" : "-".$price->da_end_range );
                    }),
                Tables\Columns\TextColumn::make("niche_start_range")
                    ->label("Niche Price")
                    ->formatStateUsing(function (PriceChart $price) {
                        return  $price->niche_start_range ."-".$price->niche_end_range ;
                    }),
                Tables\Columns\TextColumn::make("gp_start_range")
                    ->label("GP Price")
                    ->formatStateUsing(function (PriceChart $price) {
                        return  $price->gp_start_range ."-".$price->gp_end_range ;
                    }),
            ])
            ->filters([
                //
            ])
            ->actions([
//                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
//                Tables\Actions\BulkActionGroup::make([
//                    Tables\Actions\DeleteBulkAction::make(),
//                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPriceCharts::route('/'),
            'create' => Pages\CreatePriceChart::route('/create'),
            'edit' => Pages\EditPriceChart::route('/{record}/edit'),
        ];
    }
}
