<?php

namespace App\Filament\Resources\PendingBulkUploadRequestsResource\Pages;

use App\Exceptions\ExcelFileHeadingNotFound;
use App\Filament\Resources\PendingBulkUploadRequestsResource;
use App\Harman\Helpers\FileLivewireUpload;
use App\Imports\NewSiteImport;
use App\Models\BulkUpload;
use App\Project\Site\BulkSiteStatus;
use App\Project\Site\NewSiteStatus;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\Page;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Livewire\WithFileUploads;
use Maatwebsite\Excel\Facades\Excel;

class UploadExcelFile extends Page implements HasForms
{

    use InteractsWithForms;

    public ?array $data = [];


    public $record;

    public $upload_excel;

    protected static string $resource = PendingBulkUploadRequestsResource::class;

    protected static string $view = 'filament.resources.pending-bulk-upload-requests-resource.pages.upload-excel-file';

    use WithFileUploads;

    public function mount(): void
    {
        $this->form->fill();
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                FileUpload::make("upload_excel")
                    ->label("Upload Excel File")
                    ->previewable(false)
                    ->directory("uploads/excel")
                    ->required()->acceptedFileTypes(["text/csv","application/vnd.ms-excel","application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"]),

            ])
            ->statePath('data');
    }


    public function create(Request $request)
    {
        $data = $this->form->getState();
        $filename  = $data['upload_excel'];

//        dd($filename);
        try {

            $bulk =  BulkUpload::with("vendor")->findOrFail($this->record);

            $bulk->status = 1;
            $bulk->save();



            Excel::import(new NewSiteImport(
                $bulk->vendor_id,
                NewSiteStatus::PENDING,
                "Upload By User",
                $this->record,
                BulkSiteStatus::ADMIN_APPROVED_AND_UPLOADED
            ),public_path()."/$filename");

            Notification::make("success")->title("Excel File Uploaded")->send();

            $this->redirect(PendingBulkUploadRequestsResource::getUrl());
        }catch (ExcelFileHeadingNotFound|\Exception $exception){
            dd($exception->getMessage());
//            return redirect()->back()->with("error",$exception->getMessage());
        }
    }
}
