<?php

namespace App\Filament\Pages;

use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Pages\Page;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Illuminate\Contracts\Support\Htmlable;

class WalletHistory extends Page implements HasForms,HasTable
{
    use InteractsWithForms;
    use InteractsWithTable;

    protected static bool $shouldRegisterNavigation = false;
    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.pages.wallet-history';

    public function getHeading(): string|Htmlable
    {
        return "Wallet History (Balance:".admin_vendor_balance(request('id'))." )";
    }


    public function table(Table $table): Table
    {
        return $table
            ->query(
                \App\Models\WalletHistory::with("new_order_process_detail.new_order_process.new_order")->whereHas('wallet',function ($q) {
                    $q->where('user_id',request('id'));
                })
            )
            ->columns([
                TextColumn::make("created_at"),
                TextColumn::make("price")->label("Credit")->formatStateUsing(function (\App\Models\WalletHistory $record) {
                    if($record->type == 'credit' ){
                        return $record->price;
                    }else{
                        return '-';
                    }
                }),
                TextColumn::make("id")->label("Debit")->formatStateUsing(function (\App\Models\WalletHistory $record) {
                    if ($record->type == 'debit') {
                        return $record->price;
                    } else {
                        return '-';
                    }
                }),
                TextColumn::make("status")->label("Status")->formatStateUsing(function (\App\Models\WalletHistory $record) {
                    if( $record->status == 0 && $record->type == 'debit' ){
                        return 'Pending';
                    }
                    if($record->status == 1 && $record->type == 'debit' ){
                        return 'Approved';
                    }
                }),
                TextColumn::make("remarks")->label("Remarks")->formatStateUsing(function (\App\Models\WalletHistory $record) {
                    if($record->status == 1 && $record->type == 'debit'){
                        return $record->remarks;
                    }
                }),
                TextColumn::make("updated_at")->label("Order Id")->formatStateUsing(function (\App\Models\WalletHistory $record) {
                    if( $record->type == 'credit' ){
                        return optional(optional(optional($record->new_order_process_detail)->new_order_process)->new_order)->order_id;
                    }
                })
            ])
            ->filters([
                // ...
            ])
            ->actions([
                // ...
            ])
            ->bulkActions([
                // ...
            ]);
    }

}
