<?php

namespace App\Filament\Pages;

use App\Models\AssignPermission;
use App\Models\Permission;
use App\Models\User;
use Filament\Forms\Components\CheckboxList;
use Filament\Forms\Components\Section;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Notifications\Notification;
use Filament\Pages\Page;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Illuminate\Support\Facades\DB;

class UsersPermissions extends Page implements HasForms
{
    use InteractsWithForms;

    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.pages.users-permissions';

    public $user_permissions = [];
    public $user_id;

    protected static bool $shouldRegisterNavigation = false;

    public ?array $data = [];

    public function mount(): void
    {
        $assign_permissions= AssignPermission::where('user_id',request('id'))->get();
        if($assign_permissions ){
            $this->user_permissions = $assign_permissions->pluck("permission_id")->toArray();
        }else{
            $this->user_permissions = [];
        }

        $this->user_id = request('id');

        $this->form->fill([
            "user_permissions" => $this->user_permissions
        ]);
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
               Section::make("permissions")->schema([
                   CheckboxList::make("user_permissions")->options(function ()  {
                       $user= User::whereId($this->user_id)->first();
                       $permissions = Permission::where('role',$user->role)->get()->pluck("name","id");
                       return $permissions;
                   })->columns(4)
               ])
            ])
            ->statePath('data');
    }

    public function create(): void
    {
        $data = $this->form->getState();


        try{
            DB::beginTransaction();

            AssignPermission::where('user_id',$this->user_id)->delete();
            foreach ($data['user_permissions'] as $per){
                $p = new AssignPermission();
                $p->user_id = $this->user_id;
                $p->permission_id = $per;
                $p->save();
            }

            DB::commit();
            Notification::make("success")->title("Permissions Updated Successfully")->send();
        }catch (\Exception $exception){
            DB::rollBack();
            dd($exception->getMessage());
        }
    }


}
