<?php

namespace App\Filament\Pages;

use App\Filament\Resources\OrderResource;
use App\Models\NewOrderProcessDetail;
use App\Project\NewOrderStatus;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Pages\Page;
use Filament\Tables\Actions\Action;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;

class PendingOrders extends Page implements HasTable,HasForms
{
    use InteractsWithTable;
    use InteractsWithForms;

    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.pages.pending-orders';

    protected static bool $shouldRegisterNavigation = false;
    public static function shouldRegisterSpotlight(): bool
    {
        return false;
    }
    public function table(Table $table): Table
    {
        return $table
            ->query(
                NewOrderProcessDetail::where('vendor_id',request('id'))->whereIn('status',[NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER,NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER])
            )
            ->columns([
                TextColumn::make('new_order_process.new_order.order_id'),
                TextColumn::make('new_site.root_domain'),
            ])
            ->filters([
                // ...
            ])
            ->actions([
                Action::make("detail")->url(function (NewOrderProcessDetail $record) {
                    return OrderResource::getUrl('detail', ['record' => $record->new_order_process->new_order->id]);
                })
            ])
            ->bulkActions([
                // ...
            ]);
    }
}
