<?php

namespace App\Filament\Pages;

use App\Models\User;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Notifications\Notification;
use Filament\Pages\Page;
use Illuminate\Support\Facades\Hash;

class ChangePassword extends Page implements HasForms
{
    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.pages.change-password';

    protected static bool $shouldRegisterNavigation = false;

    use InteractsWithForms;

    public ?array $data = [];

    public function mount(): void
    {
        $this->form->fill();
    }
    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make("")
                    ->schema([
                        TextInput::make("old_password")->password()->required()->label("Old Password"),
                        TextInput::make("password")->password()->required()->confirmed()->label("New Password"),
                        TextInput::make("password_confirmation")->password()->required()->label("Confirm Password"),
                    ])
            ])
            ->statePath('data');
    }

    public function create()
    {
        $data = $this->form->getState();
//        dd(auth()->user()->password);
        try {
            # Match The Old Password
            if(!Hash::check($data['old_password'], auth()->user()->password)){
                return Notification::make("error")->title("Old Password Doesn't match!")->danger()->send();
//                return redirect()->back()->with("error", "Old Password Doesn't match!");
            }

            # Update the new Password
            User::whereId(auth()->user()->id)->update([
                'password' => Hash::make($data['password'])
            ]);
            Notification::make("error1")->title("Password changed successfully!")->success()->send();
            $this->form->fill([]);
//            return redirect()->to("/user/login");
        }catch (\Exception $exception){
            dd($exception->getMessage());
//            return redirect()->back()->with("error",);
        }
    }

}
