<?php

namespace App\Filament\Pages;

use App\Exports\WithdrawRequestExport;
use App\Models\User;
use App\Models\WithdrawRequest;
use Carbon\Carbon;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Pages\Page;
use Filament\Tables\Actions\Action;
use Filament\Tables\Columns\Summarizers\Sum;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Enums\FiltersLayout;
use Filament\Tables\Filters\Filter;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\HtmlString;
use Maatwebsite\Excel\Facades\Excel;
use Malzariey\FilamentDaterangepickerFilter\Filters\DateRangeFilter;

class BloggersWallet extends Page implements HasForms, HasTable
{
    use InteractsWithTable;
    use InteractsWithForms;

    protected static ?string $navigationGroup = "Wallet";

    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.pages.bloggers-wallet';

    public function table(Table $table): Table
    {
        return $table
            ->query(
                    User::join('wallets', 'users.id', '=', 'wallets.user_id')
                    ->join('wallet_histories', 'wallets.id', '=', 'wallet_histories.wallet_id')
                    ->select('users.id', 'users.name','users.email', DB::raw('SUM(wallet_histories.price) as total_price'))
                    ->where('wallet_histories.approved_date', '=', null)
                    ->groupBy('users.id', 'users.name','users.email')
            )

            ->defaultSort("total_price","desc")
            ->columns([

                TextColumn::make('name')
                    ->description(function (User $record) {
                        return $record->email;
                    })
                    ->sortable()->searchable(),

                TextColumn::make("total_price")->sortable()->label("Wallet Balance")

            ])
            ->paginated(config('app.pagination'))
            ->filtersLayout(FiltersLayout::AboveContentCollapsible)
            ->filters([

            ])
            ->actions([

            ])
            ->bulkActions([

            ]);
    }
}
