<?php

namespace App\Filament\Pages;

use App\Exceptions\ExcelFileHeadingNotFound;
use App\Harman\Helpers\FileLivewireUpload;
use App\Harman\Helpers\FileUpload;
use App\Imports\NewSiteImport;
use App\Project\Site\NewSiteStatus;
use Filament\Notifications\Notification;
use Filament\Pages\Page;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Livewire\WithFileUploads;
use Maatwebsite\Excel\Facades\Excel;
use Maatwebsite\Excel\HeadingRowImport;

class AddExcelFile extends Page
{
    protected static ?string $navigationGroup = "Sites";
    protected static ?string $navigationIcon = 'heroicon-o-document-check';

    protected static string $view = 'filament.pages.add-excel-file';

    public $upload_excel;

    use WithFileUploads;

    public function create(Request $request)
    {
        $this->validate([
            "upload_excel" => "required|mimes:csv,xlsx"
        ]);
        try {
            $file = new FileLivewireUpload($this->upload_excel,  "/excel","temp_excel_");
            $filename = $file->upload();




            Excel::import(new NewSiteImport(
                Auth::id(),
                NewSiteStatus::APPROVED,
                "Upload By Admin",
                null,
                null
            ),public_path()."/uploads/$filename");

            Notification::make("success")->title("Excel File Uploaded")->send();

        }catch (ExcelFileHeadingNotFound|\Exception $exception){
            dd($exception->getMessage());
//            return redirect()->back()->with("error",$exception->getMessage());
        }
    }


}
