<?php

namespace App\Filament\Manager\Widgets;

use App\Models\NewOrderProcessDetail;
use App\Project\NewOrderStatus;
use Carbon\Carbon;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Support\Facades\Auth;

class TodayRejectedOrdersForBloggersWidget extends BaseWidget
{
    protected static ?string $pollingInterval = null;

    protected static bool $isDiscovered = false;

    protected int | string | array $columnSpan = 2;
    public function table(Table $table): Table
    {
        return $table
            ->query(
                NewOrderProcessDetail::whereHas('new_order_process',function ($q){
                    $q->where('manager_id',Auth::id());
                })
                    ->where('status',NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION)
                ->whereDate('created_at',Carbon::today())
            )
            ->columns([
                Tables\Columns\TextColumn::make("new_order_process.new_order.order_id")->label("Order Id"),
                Tables\Columns\TextColumn::make("vendor.name")->description(function (NewOrderProcessDetail $record) {
                    return $record->vendor->email;
                }),
                Tables\Columns\TextColumn::make("new_site.root_domain"),
                Tables\Columns\TextColumn::make("status")
                    ->badge()
                    ->color(function (NewOrderProcessDetail $record) {
                        switch ($record->status) {
                            case NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS:
                                return "success";
                            case NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION:
                                return "danger";
                        }
                    })
                    ->formatStateUsing(function (NewOrderProcessDetail $record) {
                        switch ($record->status) {
                            case NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS:
                                return "Accepted";
                            case NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION:
                                return "Rejected";


                        }
                    }),

                Tables\Columns\TextColumn::make("reject_reason")->wrap(),
            ]);
    }
}
