<?php

namespace App\Filament\Manager\Widgets;

use App\Filament\Manager\Resources\PendingApprovalForWriterResource;
use App\Models\NewOrder;
use App\Models\NewOrderProcess;
use App\Models\NewOrderProcessDetail;
use App\Project\NewOrderStatus;
use Carbon\Carbon;
use Filament\Forms\Components\Textarea;
use Filament\Notifications\Notification;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class TodayPendingApprovalsForWritersWidget extends BaseWidget
{
    protected static ?string $pollingInterval = null;

    protected static bool $isDiscovered = false;

    protected int | string | array $columnSpan = 2;
    public function table(Table $table): Table
    {
        return $table
            ->query(
                NewOrder::with("order_processes_writer_pushed_to_manager.new_order_process_details")
                    ->whereHas("order_processes_team_pushed_to_manager",function ($q){
                        $q->whereDate('created_at',Carbon::today());
                    })
                    ->where('manager_id',Auth::id())
                    ->where('new_order_status',NewOrderStatus::$WRITER_PUSHED_TO_MANAGER)
            )
            ->columns([
                Tables\Columns\TextColumn::make("order_id"),
                Tables\Columns\TextColumn::make("client_name"),
                Tables\Columns\TextColumn::make("client_website"),
                Tables\Columns\TextColumn::make("no_of_links"),
                Tables\Columns\TextColumn::make("order_type"),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\Action::make("detail")->url(function (NewOrder $record) {
                    return  PendingApprovalForWriterResource::getUrl('detail', ['record' => $record->id]);
                }),
                Tables\Actions\Action::make("post_disapproved")->form([
                    Textarea::make("note")->label("Note")
                ])->action(function (NewOrder $record, array $data) {
                    $order = NewOrder::with("order_processes_writer_pushed_to_manager.new_order_process_details")
                        ->where('manager_id', Auth::id())
                        ->where('new_order_status', NewOrderStatus::$WRITER_PUSHED_TO_MANAGER)
                        ->where('id', $record->id)->firstorFail();

                    $status= NewOrderStatus::$MANAGER_REJECTED_AND_PUSHED_BACK_TO_WRITER;

                    try{
                        DB::beginTransaction();
                        $order->new_order_status = $status;
                        $order->save();

                        $new_order_process= new NewOrderProcess();
                        $new_order_process->new_order_id= $order->id;
                        $new_order_process->writer_id= $order->order_processes_writer_pushed_to_manager->writer_id;
                        $new_order_process->manager_id= Auth::id();
                        $new_order_process->note = $data['note'];
                        $new_order_process->status = $status;
                        $new_order_process->save();

                        foreach ($order->order_processes_writer_pushed_to_manager->new_order_process_details as $det) {
                            $detail = new NewOrderProcessDetail();
                            $detail->new_order_process_id = $new_order_process->id;
                            $detail->new_site_id = $det->new_site_id;
                            $detail->url = $det->url;
                            $detail->price = $det->price;
                            $detail->anchor = $det->anchor;
                            $detail->title = $det->title;
                            $detail->ourl = $det->ourl;
                            $detail->doc_urls = $det->doc_urls;
                            $detail->upload_doc_file = $det->upload_doc_file;
                            $detail->insert_after = $det->insert_after;
                            $detail->statement = $det->statement;
                            $detail->note = $det->note;
                            $detail->vendor_id = $det->new_site->uploaded_user_id;
                            $detail->status = $status;
                            $detail->save();

                        }

                        DB::commit();
                        Notification::make("success")->title("Pushed Back to Writer")->send();
                    }catch (\Exception $exception){
                        DB::rollBack();
                        dd($exception->getMessage());
                    }
                })
            ]);
    }
}
