<?php

namespace App\Filament\Manager\Widgets;

use App\Filament\Manager\Resources\PendingApprovalForBloggersResource;
use App\Models\NewOrder;
use App\Models\NewOrderProcessDetail;
use App\Project\NewOrderStatus;
use Carbon\Carbon;
use Filament\Forms\Components\Textarea;
use Filament\Notifications\Notification;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class TodayPendingApprovalsForBloggersWidget extends BaseWidget
{
    protected static ?string $pollingInterval = null;

    protected static bool $isDiscovered = false;

    protected int | string | array $columnSpan = 2;
    public function table(Table $table): Table
    {
        return $table
            ->query(
                NewOrderProcessDetail::whereHas('new_order_process',function ($q){
                    $q->where('manager_id',Auth::id());
                })->where('status',NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS)->whereDate('created_at',Carbon::today())
            )
            ->columns([
                Tables\Columns\TextColumn::make("new_order_process.new_order.order_id")->label("Order Id"),
                Tables\Columns\TextColumn::make("vendor.name")->description(function (NewOrderProcessDetail $record) {
                    return $record->vendor->email;
                }),
                Tables\Columns\TextColumn::make("new_site.root_domain"),
                Tables\Columns\TextColumn::make("status")
                    ->badge()
                    ->color(function (NewOrderProcessDetail $record) {
                        switch ($record->status) {
                            case NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS:
                                return "success";
                            case NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION:
                                return "danger";
                        }
                    })
                    ->formatStateUsing(function (NewOrderProcessDetail $record) {
                        switch ($record->status) {
                            case NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS:
                                return "Accepted";
                            case NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION:
                                return "Rejected";


                        }
                    }),
            ]) ->actions([
                Tables\Actions\Action::make("detail")->url(function (NewOrderProcessDetail $record) {
                    return PendingApprovalForBloggersResource::getUrl('detail', ['record' => $record->id]);
                }),
                Tables\Actions\Action::make("reject_post")->form([
                    Textarea::make("note")->label("Note")
                ])->action(function (NewOrder $record, array $data) {
                    try{
                        DB::beginTransaction();
                        $order= NewOrderProcessDetail::with("new_order_process.new_order","new_site.uploaded_user")->where('id',$record->id)->firstOrFail();

                        $order->status = NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER;
                        $order->note = $data['note'];
                        $order->save();

                        DB::commit();
                        Notification::make("success")->title("Rejected and Pushed Back to Blogger Successfully")->send();
                    }catch (\Exception $exception){
                        DB::rollBack();
                        dd($exception->getMessage());
                    }
                })
            ]);
    }
}
