<?php

namespace App\Filament\Manager\Resources\PendingApprovalForTeamResource\Pages;

use App\Filament\Manager\Resources\PendingApprovalForTeamResource;
use App\Filament\Team\Resources\OrderAddedNotificationsResource;
use App\Models\NewOrder;
use App\Models\NewOrderProcess;
use App\Models\NewOrderProcessDetail;
use App\Models\User;
use App\Project\NewOrderStatus;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Forms\Get;
use Filament\Infolists\Components\Section;
use Filament\Infolists\Components\TextEntry;
use Filament\Infolists\Concerns\InteractsWithInfolists;
use Filament\Infolists\Contracts\HasInfolists;
use Filament\Infolists\Infolist;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\Page;
use Filament\Support\Enums\FontWeight;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\HtmlString;

class DetailPage extends Page implements HasForms, HasInfolists
{
    use InteractsWithForms;
    use InteractsWithInfolists;

    public ?array $data = [];

    public $record;

    public $order;

    protected static string $resource = PendingApprovalForTeamResource::class;

    protected static string $view = 'filament.manager.resources.pending-approval-for-team-resource.pages.detail-page';


    public function mount(int | string $record): void
    {
        $this->order = NewOrder::has("order_processes_team_pushed_to_manager")
            ->with("order_processes_team_pushed_to_manager.new_order_process_details")
            ->where('id',$this->record)->where('manager_id',Auth::id())->first();

        $data  = [];

        foreach($this->order->order_processes_team_pushed_to_manager->new_order_process_details as $details){
            $data[] = [
                "id"    =>  $details->id,
                "root_domain" => $details->new_site->root_domain,
                "post_url"  =>  $details->url,
                "price" => $details->price,
                "note"  => $details->new_note,
                "url" => "",
                "anchor" => "",
                "title" => "",
            ];
        }

//        dd($data);
        $this->form->fill(["details"    =>  $data]);

    }

    public function render(): View
    {
        return parent::render();
    }

    public function OrderInfolist(Infolist $infolist): Infolist
    {
        return $infolist
            ->record($this->order)
            ->schema([
                Section::make("Order Details")->schema([
                    TextEntry::make("created_at")->label("Order Date")->weight(FontWeight::Medium)->color('primary'),
                    TextEntry::make("order_processes_team_pushed_to_manager.created_at")->label("Pushed Date")->weight(FontWeight::Medium)->color('primary'),
                    TextEntry::make("order_id")->label("Order Id")->weight(FontWeight::Medium)->color('primary'),
                    TextEntry::make("order_type")->label("Order Type")->weight(FontWeight::Medium)->color('primary'),
                    TextEntry::make("client_name")->label("Client Name")->weight(FontWeight::Medium)->color('primary'),

                    TextEntry::make("client_website")->columnSpan(2)->label("Client Website")->weight(FontWeight::Medium)->color('primary'),

                    TextEntry::make("no_of_links")->label("No of Links")->weight(FontWeight::Medium)->color('primary'),
                    TextEntry::make("order_package")->label("Order Package")->columnSpan(2)->weight(FontWeight::Medium)->color('primary'),
                    TextEntry::make("team.name")->label("Team")
                        ->formatStateUsing(function ($record){
                            return new HtmlString($record->team->name.'<br>'.$record->team->email);
                        })
                        ->columnSpan(2)
                        ->weight(FontWeight::Medium)->color('primary'),
                    TextEntry::make("order_processes_team_pushed_to_manager.note")->label("Push Note")->columnSpan(3)->weight(FontWeight::Medium)->color('primary'),

                    TextEntry::make("message")->columnSpanFull()->formatStateUsing(function ($state){
                        return new HtmlString($state);
                    })
                ])->columns(5)->collapsed()
            ]);
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                \Filament\Forms\Components\Section::make("Push To Writer")->schema([
                    Repeater::make("details")
                        ->label(" ")
                        ->addable(false)
                        ->orderable(false)
                        ->deletable(false)
                        ->extraItemActions([

                        ])
                        ->schema([
                            Placeholder::make("root_domain")
                                ->inlineLabel()->content(function (Get $get){
                                    return $get('root_domain');
                                }),
                            Placeholder::make("post_url")
                                ->inlineLabel()->content(function (Get $get){
                                    return $get('post_url');
                                })->hidden(function (Get $get){
                                    if($this->order->order_type == "niche"){
                                        return false;
                                    }
                                    return true;
                                }),
                            Placeholder::make("price")
                                ->inlineLabel()->content(function (Get $get){
                                    return $get('price');
                                }),
                            Placeholder::make("note")
                                ->inlineLabel()->content(function (Get $get){
                                    return $get('note');
                                }),
                            TextInput::make("url")->inlineLabel()->required(),
                            TextInput::make("anchor")->inlineLabel()->required(),
                            TextInput::make("title")
                                ->hidden(function (Get $get){
                                    if($this->order->order_type == "niche"){
                                        return true;
                                    }
                                    return false;
                                })
                                ->inlineLabel()->required(),
                        ]),

                    Textarea::make("note")->label("Note..."),
                    Select::make("writer")->label("Select Writer")
                        ->required()
                        ->options(User::where('role','writer')->pluck('name','id')->toArray())
                ])
            ])

            ->statePath('data');
     }



    public function create(): void
    {
        $data = $this->form->getState();



        try {
            DB::beginTransaction();

            $status=NewOrderStatus::$MANAGER_PUSHED_TO_WRITER;

            $new_order_process= new NewOrderProcess();
            $new_order_process->new_order_id= $this->order->id;
            $new_order_process->writer_id= $data['writer'];
            $new_order_process->manager_id= Auth::id();
            $new_order_process->note = $data['note'];
            $new_order_process->status = $status;
            $new_order_process->save();

            $this->order->new_order_status = $status;
            $this->order->save();


            foreach ( $data['details'] as  $val ) {
                $d= NewOrderProcessDetail::where('id',$val['id'])->firstOrFail();

                $detail= new NewOrderProcessDetail();
                $detail->new_order_process_id= $new_order_process->id;
                $detail->new_site_id= $d->new_site_id;
                $detail->url = $d->url;
                $detail->price= $d->price;
                if( $this->order->order_type == "gp" ) {
                    $detail->anchor = $val['anchor'];
                    $detail->title = $val['title'];
                    $detail->ourl = $val['url'];
                }
                if( $this->order->order_type == "niche" ) {
                    $detail->anchor = $val['anchor'];
                    $detail->ourl = $val['url'];
                }
                $detail->save();
            }

            $writer= User::where('role','writer')->where('id',$data['writer'])->first();
            $admin = User::where('role','admin')->first();

            Notification::make()
                ->title("Order Pushed by ".Auth::user()->name.'('.Auth::user()->email.')')
                ->body("Order No: ".$this->order->order_id)
                ->success()
                ->sendToDatabase([$writer,$admin]);

            DB::commit();

            Notification::make("success")->title("Successfully Pushed to Writer")->send();
            $this->redirect(PendingApprovalForTeamResource::getUrl("index"));
//                return redirect()->route("team.dashboard")->with("success","Successfully pushed to manager");
        }catch (\Exception $exception){
            DB::rollBack();
            dd($exception->getMessage());
        }
    }

}
