<?php

namespace App\Filament\Manager\Resources\PendingApprovalForBloggersResource\Pages;

use App\Filament\Manager\Resources\PendingApprovalForBloggersResource;
use App\Models\NewOrderProcessDetail;
use App\Models\User;
use App\Models\Wallet;
use App\Models\WalletHistory;
use App\Project\NewOrderStatus;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\Section;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Forms\Get;
use Filament\Infolists\Concerns\InteractsWithInfolists;
use Filament\Infolists\Contracts\HasInfolists;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\Page;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\HtmlString;

class DetailPage extends Page implements HasForms, HasInfolists
{
    use InteractsWithForms;
    use InteractsWithInfolists;

    public ?array $data = [];

    public $record;
    public $order;

    protected static string $resource = PendingApprovalForBloggersResource::class;

    protected static string $view = 'filament.manager.resources.pending-approval-for-bloggers-resource.pages.detail-page';

    public function mount(int | string $record): void
    {
        $this->order= NewOrderProcessDetail::whereHas('new_order_process',function ($q){
            $q->where('manager_id',Auth::id());
        })->whereIn('status',[NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION,NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS])
            ->where('id',$this->record)
            ->firstOrFail();




        $this->form->fill([
            "order_id"    =>  $this->order->new_order_process->new_order->order_id,
            "vendor"    =>  $this->order->vendor->name .' ( '.$this->order->vendor->email.' )',
            "root_domain"   =>  $this->order->new_site->root_domain,
            "post_url"      =>  $this->order->url,
            "type"          =>  $this->order->type,
            "insert_after"  =>  $this->order->insert_after,
            "statement"  =>  $this->order->statement,
            "anchor"  =>  $this->order->anchor,
            "url"  =>  $this->order->ourl,
            "submit_url"  =>  $this->order->submit_url,
            "verify"  =>  $this->order->verify,
        ]);
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make("Blogger Pushed Data")->schema([
                    Placeholder::make("order_id")
                        ->inlineLabel()->content(function (Get $get){
                            return $get('order_id');
                        }),

                    Placeholder::make("vendor")
                        ->inlineLabel()->content(function (Get $get){
                            return $get('vendor');
                        }),
                    Placeholder::make("root_domain")
                        ->inlineLabel()->content(function (Get $get){
                            return $get('root_domain');
                        }),
                    Placeholder::make("post_url")
                        ->inlineLabel()->content(function (Get $get){
                            return $get('post_url');
                        }),

                    Placeholder::make("type")
                        ->label(function (Get $get){
                            if( $get("type") == 'replace' ){
                                return 'Replace With';
                            }

                            return 'Insert After';
                        })
                        ->inlineLabel()->content(function (Get $get){
                            return  new HtmlString($get("insert_after"));
                        }),

                    Placeholder::make("type")
                        ->label(function (Get $get){
                            if( $get("type") == 'replace' ){
                                return 'Replace Statement';
                            }

                            return 'Insert Statement';
                        })
                        ->inlineLabel()->content(function (Get $get){
                            return  new HtmlString($get("statement"));
                        }),

                    Placeholder::make("anchor")
                        ->inlineLabel()->content(function (Get $get){
                            return $get('anchor');
                        }),

                    Placeholder::make("url")
                        ->inlineLabel()->content(function (Get $get){
                            return $get('url');
                        }),

                    Placeholder::make("verify")->label("Link Verification")
                        ->inlineLabel()->content(function (Get $get){
                            return $get('verify');
                        }),

                    Placeholder::make("submit_url")
                        ->inlineLabel()->content(function (Get $get){
                            return $get('submit_url');
                        }),


                ])
            ])

            ->statePath('data');
    }

    public function create(): void
    {
        $data = $this->form->getState();

        try{
            DB::beginTransaction();
            $order= NewOrderProcessDetail::with("new_order_process.new_order","new_site.uploaded_user")->whereHas('new_order_process',function ($q){
                $q->where('manager_id',Auth::id());
            })->whereIn('status',[NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION,NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS])
                ->where('id',$this->order->id)
                ->firstOrFail();
//            dd();
            $order_type= $order->new_order_process->new_order->order_type;
            $name = $order->new_site->uploaded_user->name;
            $email = $order->new_site->uploaded_user->email;
            $order_number= $order->new_order_process->new_order->order_id;
            $root_domain = $order->new_site->root_domain;

            $price= $order->price;

            $order->status = NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED;
            $order->save();

            $order->new_order_process->new_order->completed_tasks = $order->new_order_process->new_order->completed_tasks + 1;
            $order->new_order_process->new_order->save();
//            $price= $order_type == 'gp' ? $order->new_site->gp_price : $order->new_site->niche_edit_price;
            //check wallet is available or not
            $check= Wallet::where('user_id',$order->vendor_id)->first();
            if( !$check ){
                $new= new Wallet();
                $new->user_id= $order->vendor_id;
                $new->balance= $price;
                $new->save();

                $history= new WalletHistory();
                $history->wallet_id= $new->id;
                $history->order_detail_id= $order->id;
                $history->type = "credit";
                $history->price=  $price;
                $history->save();
            }else{
                $check->balance= $check->balance + $price;
                $check->save();

                $history= new WalletHistory();
                $history->wallet_id= $check->id;
                $history->order_detail_id= $order->id;
                $history->type = "credit";
                $history->price=  $price;
                $history->save();
            }

//            Mail::to($email)->send(new OrderCompletionMail($name,$order_number,$root_domain,$price));


            DB::commit();


            Notification::make("success")->title("Order Finished")->send();

            $blogger= User::where('role','vendor')->where('id',$order->vendor_id)->first();

            Notification::make()
                ->title("Order Finished")
                ->body("Order No: ".$order->new_order_process->new_order->order_id)
                ->success()
                ->sendToDatabase([$blogger]);

            $this->redirect(PendingApprovalForBloggersResource::getUrl("index"));
//            return redirect()->route("manager.pending_approvals_for_bloggers")->with("success","Order Finished");
        }catch (\Exception $exception){
            DB::rollBack();
            dd($exception->getMessage());
//            session()->flash("error",$exception->getLine());
        }

    }

}
