<?php

namespace App\Filament\Blogger\Widgets;

use App\Filament\Blogger\Resources\OrderResource;
use App\Harman\Helpers\NewLinkVerify;
use App\Models\NewOrderProcessDetail;
use App\Project\NewOrderStatus;
use Carbon\Carbon;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\TextInput;
use Filament\Notifications\Notification;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\HtmlString;
use Malzariey\FilamentDaterangepickerFilter\Filters\DateRangeFilter;

class TodayOrderWidget extends BaseWidget
{
    protected static bool $isDiscovered = false;
    protected static ?string $heading  = "Today Pending Orders";
    protected int | string | array $columnSpan  = 2;
    public function table(Table $table): Table
    {
        return $table
            ->query(
                NewOrderProcessDetail::where('vendor_id',Auth::id())
                    ->whereDate('created_at',Carbon::today())
                    ->whereIn('status',[NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER])

            )
            ->paginated(config("app.pagination"))
            ->recordUrl(null)
            ->striped()
            ->columns([
                Tables\Columns\TextColumn::make("new_order_process.new_order.order_id")->label("Order Id"),
                Tables\Columns\TextColumn::make("new_site.root_domain")->label("Root Domain"),
                Tables\Columns\TextColumn::make("created_at")->label("Date/Time"),
            ])
            ->filtersLayout(Tables\Enums\FiltersLayout::AboveContent)
            ->filters([
                DateRangeFilter::make("created_at")->label("Search By Date"),
                Tables\Filters\Filter::make("Search")->form([
                    TextInput::make("order_id")->label("Order Id"),
                    TextInput::make("root_domain")->label("Search by Root Domain"),
                ])->query(function (Builder $query,$data){
                    return $query
                        ->when($data['order_id'],function (Builder $query) use ($data) {
                            $query->whereHas("new_order_process.new_order",function (Builder $query) use ($data){
                                $query->where('order_id','LIKE','%'.$data['order_id'].'%');
                            });
                        })
                        ->when($data['root_domain'],function (Builder $query) use ($data) {
                            $query->whereHas("new_site",function (Builder $query) use ($data){
                                $query->where('root_domain','LIKE','%'.$data['root_domain'].'%');
                            });
                        })
                        ;
                })->columnSpan(4)->columns(4)
            ])
            ->actions([
                Tables\Actions\Action::make("detail")->label(" ")
                    ->icon("heroicon-o-eye")
                    ->tooltip("View")
                    ->slideOver()
                    ->modalHeading(function ($record){
                        $detail = $record;
                        if($detail->status == NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED) return 'Completed';
                        if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION) return 'Blogger Rejected the Order';
                        if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS) return 'Waiting From Manager';
                        if($detail->status == NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER) return 'Pending Order';
                        if($detail->status == NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER) return 'Rejected by Manager';
                    })

                    ->form([

                        Placeholder::make("status")->content(function ($record){
                            $detail = $record;
                            if($detail->status == NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED) return new HtmlString('<span style="background: blue;color: white;padding:2px 8px;display: inline-block">Completed</span>');
                            if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION) return 'Blogger Rejected the Order';
                            if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS) return 'Waiting From Manager';
                            if($detail->status == NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER) return new HtmlString('<span style="background: orange;color: white;padding:2px 8px;display: inline-block">Pending Order</span>');
                            if($detail->status == NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER) return 'Rejected by Manager';
                            return '';
                        })->inlineLabel(),

                        Placeholder::make("order_id")->label("Order ID")->content(function ($record){
                            return $record->new_order_process->new_order->order_id;
                        })->inlineLabel(),

                        Placeholder::make("root_domain")->label("Root Domain")->content(function ($record){
                            return $record->new_site->root_domain;
                        })->inlineLabel(),

                        //Order Type Niche
                        Placeholder::make("urls")->label("Post Urls")->content(function ($record){
                            return $record->url;
                        })->hidden(function ($record){
                            if($record->new_order_process->new_order->order_type == "niche"){
                                return false;
                            }
                            return true;
                        })
                            ->inlineLabel(),

                        Placeholder::make("insert_after")->label(function ($record){
                            $detail = $record;
                            return ($detail->type == 'replace') ? 'Replace With' : 'Insert After';
                        })->content(function ($record){
                            return new HtmlString($record->insert_after);
                        })->hidden(function ($record){
                            if($record->new_order_process->new_order->order_type == "niche"){
                                return false;
                            }
                            return true;
                        })
                            ->inlineLabel(),


                        Placeholder::make("statement")->label(function ($record){
                            $detail = $record;
                            return ($detail->type == 'replace') ? 'Replace Statement' : 'Insert Statement';
                        })->content(function ($record){
                            return new HtmlString($record->statement);
                        })->hidden(function ($record){
                            if($record->new_order_process->new_order->order_type == "niche"){
                                return false;
                            }
                            return true;
                        })
                            ->inlineLabel(),
                        //END Order Type Niche



                        //Order Type GP
                        Placeholder::make("anchor")->label("Anchor")
                            ->content(fn ($record) => $record->anchor )
                            ->inlineLabel(),

                        Placeholder::make("title")->label("Title")
                            ->content(fn ($record) => $record->title )
                            ->hidden(function ($record){
                                if($record->new_order_process->new_order->order_type == "gp") return false;
                                return true;
                            })->inlineLabel(),

                        Placeholder::make("doc_urls")->label("Doc Urls")
                            ->content(fn ($record) => $record->doc_urls )
                            ->hidden(function ($record){
                                if($record->new_order_process->new_order->order_type == "gp") return false;
                                return true;
                            })->inlineLabel(),

                        Placeholder::make("upload_doc_file")->label("Doc File")
                            ->content(fn ($record) => new HtmlString('<a href="/uploads/'.$record->upload_doc_file.'">View File</a>') )
                            ->hidden(function ($record){
                                if($record->new_order_process->new_order->order_type == "gp") return false;
                                return true;
                            })->inlineLabel(),

                        Placeholder::make("ourl")->label("Url")
                            ->content(fn ($record) => $record->ourl )
                            ->inlineLabel(),

                        Placeholder::make("note")->label("Note")
                            ->content(fn ($record) => $record->note )
                            ->inlineLabel(),

                        Placeholder::make("submit_url")->label("Submit URL")
                            ->content(fn ($record) => $record->submit_url )
                            ->hidden(function ($record){
                                $detail = $record;
                                if($detail->status == NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED) return false;
                                if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION) return false;
                                if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS) return false;

                                return true;
                            })
                            ->inlineLabel(),

                        TextInput::make("submit_url")->label("Submit URL")->required()->url()


                    ])
                    ->action(function ($record, $data){
                        try{
                            $detail = $record;
                            $v =(new NewLinkVerify(trim($detail->ourl), trim($detail->anchor), trim($data['submit_url'])))->verify();


                            $detail->submit_url= $data['submit_url'];
                            $detail->verify = $v ? "verified" : "Not Verified";
                            $detail->status = NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS;
                            $detail->save();


                            Notification::make("success")->title("Successfully Pushed to Manager")->success()->send();

                            redirect()->to(OrderResource::getUrl());
                        }catch (\Exception $exception){
                            dd($exception->getMessage());
                        }
                    })
                    ->hidden(function ($record) {
                        $detail = $record;
                        if($detail->status == NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER || $detail->status == NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER){
                            return false;
                        }
                        return true;
                    }),

                Tables\Actions\Action::make("rejection")->label(" ")
                    ->icon("heroicon-o-trash")
                    ->color('danger')
                    ->tooltip("Reject Order")
                    ->slideOver()
                    ->modalHeading(function ($record){
                        $detail = $record;
                        if($detail->status == NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED) return 'Completed';
                        if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION) return 'Blogger Rejected the Order';
                        if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS) return 'Waiting From Manager';
                        if($detail->status == NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER) return 'Pending Order';
                        if($detail->status == NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER) return 'Rejected by Manager';
                    })

                    ->form([

                        Placeholder::make("status")->content(function ($record){
                            $detail = $record;
                            if($detail->status == NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED) return new HtmlString('<span style="background: blue;color: white;padding:2px 8px;display: inline-block">Completed</span>');
                            if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION) return 'Blogger Rejected the Order';
                            if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS) return 'Waiting From Manager';
                            if($detail->status == NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER) return new HtmlString('<span style="background: orange;color: white;padding:2px 8px;display: inline-block">Pending Order</span>');
                            if($detail->status == NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER) return 'Rejected by Manager';
                            return '';
                        })->inlineLabel(),

                        Placeholder::make("order_id")->label("Order ID")->content(function ($record){
                            return $record->new_order_process->new_order->order_id;
                        })->inlineLabel(),

                        Placeholder::make("root_domain")->label("Root Domain")->content(function ($record){
                            return $record->new_site->root_domain;
                        })->inlineLabel(),

                        //Order Type Niche
                        Placeholder::make("urls")->label("Post Urls")->content(function ($record){
                            return $record->url;
                        })->hidden(function ($record){
                            if($record->new_order_process->new_order->order_type == "niche"){
                                return false;
                            }
                            return true;
                        })
                            ->inlineLabel(),

                        Placeholder::make("insert_after")->label(function ($record){
                            $detail = $record;
                            return ($detail->type == 'replace') ? 'Replace With' : 'Insert After';
                        })->content(function ($record){
                            return new HtmlString($record->insert_after);
                        })->hidden(function ($record){
                            if($record->new_order_process->new_order->order_type == "niche"){
                                return false;
                            }
                            return true;
                        })
                            ->inlineLabel(),


                        Placeholder::make("statement")->label(function ($record){
                            $detail = $record;
                            return ($detail->type == 'replace') ? 'Replace Statement' : 'Insert Statement';
                        })->content(function ($record){
                            return new HtmlString($record->statement);
                        })->hidden(function ($record){
                            if($record->new_order_process->new_order->order_type == "niche"){
                                return false;
                            }
                            return true;
                        })
                            ->inlineLabel(),
                        //END Order Type Niche



                        //Order Type GP
                        Placeholder::make("anchor")->label("Anchor")
                            ->content(fn ($record) => $record->anchor )
                            ->inlineLabel(),

                        Placeholder::make("title")->label("Title")
                            ->content(fn ($record) => $record->title )
                            ->hidden(function ($record){
                                if($record->new_order_process->new_order->order_type == "gp") return false;
                                return true;
                            })->inlineLabel(),

                        Placeholder::make("doc_urls")->label("Doc Urls")
                            ->content(fn ($record) => $record->doc_urls )
                            ->hidden(function ($record){
                                if($record->new_order_process->new_order->order_type == "gp") return false;
                                return true;
                            })->inlineLabel(),

                        Placeholder::make("upload_doc_file")->label("Doc File")
                            ->content(fn ($record) => new HtmlString('<a href="/uploads/'.$record->upload_doc_file.'">View File</a>') )
                            ->hidden(function ($record){
                                if($record->new_order_process->new_order->order_type == "gp") return false;
                                return true;
                            })->inlineLabel(),

                        Placeholder::make("ourl")->label("Url")
                            ->content(fn ($record) => $record->ourl )
                            ->inlineLabel(),

                        Placeholder::make("note")->label("Note")
                            ->content(fn ($record) => $record->note )
                            ->inlineLabel(),

                        Placeholder::make("submit_url")->label("Submit URL")
                            ->content(fn ($record) => $record->submit_url )
                            ->hidden(function ($record){
                                $detail = $record;
                                if($detail->status == NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED) return false;
                                if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION) return false;
                                if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS) return false;

                                return true;
                            })
                            ->inlineLabel(),

                        TextInput::make("reason_for_rejection")->label("Reason for Rejection")->required()


                    ])
                    ->action(function ($record, $data){
                        try{
                            $detail = $record;
                            $detail->status = NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION;
                            $detail->reject_reason = $data['reason_for_rejection'];
                            $detail->save();

                            Notification::make("success")->title("Order Rejected")->success()->send();

                            redirect()->to(OrderResource::getUrl());
                        }catch (\Exception $exception){
                            dd($exception->getMessage());
                        }
                    })
                    ->hidden(function ($record) {
                        $detail = $record;
                        if($detail->status == NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER || $detail->status == NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER){
                            return false;
                        }
                        return true;
                    }),

                Tables\Actions\Action::make("info")->label(" ")
                    ->icon("heroicon-o-eye")
                    ->tooltip("View")
                    ->slideOver()
                    ->modalHeading(function ($record){
                        $detail = $record;
                        if($detail->status == NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED) return 'Completed';
                        if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION) return 'Blogger Rejected the Order';
                        if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS) return 'Waiting From Manager';
                        if($detail->status == NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER) return 'Pending Order';
                        if($detail->status == NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER) return 'Rejected by Manager';
                    })
                    ->modalSubmitAction(false)
                    ->modalCancelAction(false)
                    ->form([

                        Placeholder::make("status")->content(function ($record){
                            $detail = $record;
                            if($detail->status == NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED) return new HtmlString('<span style="background: blue;color: white;padding:2px 8px;display: inline-block">Completed</span>');
                            if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION) return 'Blogger Rejected the Order';
                            if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS) return 'Waiting From Manager';
                            if($detail->status == NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER) return new HtmlString('<span style="background: orange;color: white;padding:2px 8px;display: inline-block">Pending Order</span>');
                            if($detail->status == NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER) return 'Rejected by Manager';
                            return '';
                        })->inlineLabel(),

                        Placeholder::make("order_id")->label("Order ID")->content(function ($record){
                            return $record->new_order_process->new_order->order_id;
                        })->inlineLabel(),

                        Placeholder::make("root_domain")->label("Root Domain")->content(function ($record){
                            return $record->new_site->root_domain;
                        })->inlineLabel(),

                        //Order Type Niche
                        Placeholder::make("urls")->label("Post Urls")->content(function ($record){
                            return $record->url;
                        })->hidden(function ($record){
                            if($record->new_order_process->new_order->order_type == "niche"){
                                return false;
                            }
                            return true;
                        })
                            ->inlineLabel(),

                        Placeholder::make("insert_after")->label(function ($record){
                            $detail = $record;
                            return ($detail->type == 'replace') ? 'Replace With' : 'Insert After';
                        })->content(function ($record){
                            return new HtmlString($record->insert_after);
                        })->hidden(function ($record){
                            if($record->new_order_process->new_order->order_type == "niche"){
                                return false;
                            }
                            return true;
                        })
                            ->inlineLabel(),


                        Placeholder::make("statement")->label(function ($record){
                            $detail = $record;
                            return ($detail->type == 'replace') ? 'Replace Statement' : 'Insert Statement';
                        })->content(function ($record){
                            return new HtmlString($record->statement);
                        })->hidden(function ($record){
                            if($record->new_order_process->new_order->order_type == "niche"){
                                return false;
                            }
                            return true;
                        })
                            ->inlineLabel(),
                        //END Order Type Niche



                        //Order Type GP
                        Placeholder::make("anchor")->label("Anchor")
                            ->content(fn ($record) => $record->anchor )
                            ->inlineLabel(),

                        Placeholder::make("title")->label("Title")
                            ->content(fn ($record) => $record->title )
                            ->hidden(function ($record){
                                if($record->new_order_process->new_order->order_type == "gp") return false;
                                return true;
                            })->inlineLabel(),

                        Placeholder::make("doc_urls")->label("Doc Urls")
                            ->content(fn ($record) => $record->doc_urls )
                            ->hidden(function ($record){
                                if($record->new_order_process->new_order->order_type == "gp") return false;
                                return true;
                            })->inlineLabel(),

                        Placeholder::make("upload_doc_file")->label("Doc File")
                            ->content(fn ($record) => new HtmlString('<a href="/uploads/'.$record->upload_doc_file.'">View File</a>') )
                            ->hidden(function ($record){
                                if($record->new_order_process->new_order->order_type == "gp") return false;
                                return true;
                            })->inlineLabel(),

                        Placeholder::make("ourl")->label("Url")
                            ->content(fn ($record) => $record->ourl )
                            ->inlineLabel(),

                        Placeholder::make("note")->label("Note")
                            ->content(fn ($record) => $record->note )
                            ->inlineLabel(),

                        Placeholder::make("submit_url")->label("Submit URL")
                            ->content(fn ($record) => $record->submit_url )
                            ->hidden(function ($record){
                                $detail = $record;
                                if($detail->status == NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED) return false;
                                if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION) return false;
                                if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS) return false;

                                return true;
                            })
                            ->inlineLabel(),



                    ])
                    ->action(function ($record, $data){

                    })
                    ->hidden(function ($record) {
                        $detail = $record;
                        if($detail->status == NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER || $detail->status == NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER){
                            return true;
                        }
                        return false;
                    })

            ]);
    }
}
