<?php

namespace App\Filament\Blogger\Widgets;

use App\Filament\Blogger\Resources\OrderResource;
use App\Filament\Blogger\Resources\TicketResource;
use App\Filament\Blogger\Resources\ViewAllSitesResource;
use App\Models\NewOrderProcessDetail;
use App\Models\NewSite;
use App\Models\Thread;
use App\Project\NewOrderStatus;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Illuminate\Support\Facades\Auth;

class BloggerStatsWidget extends BaseWidget
{
    protected static ?string $pollingInterval = null;

    protected static bool $isDiscovered = false;
    protected function getStats(): array
    {
        $pending_orders= NewOrderProcessDetail::where('vendor_id',Auth::id())->whereIn('status',[NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER])->count();
        $waiting_orders= NewOrderProcessDetail::where('vendor_id',Auth::id())->whereIn('status',[NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS])->count();
        $rejected_orders= NewOrderProcessDetail::where('vendor_id',Auth::id())->whereIn('status',[NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER])->count();
        $completed_orders= NewOrderProcessDetail::where('vendor_id',Auth::id())->whereIn('status',[NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED,NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION])->count();


        $total_sites = NewSite::selectRaw("count(id) as count")->where('bulk_upload_status',null)
            ->where('bulk_upload_id',null)
            ->where('delete_site',null)
            ->where('uploaded_user_id',Auth::id())->first();
        return [
            Stat::make("Total Sites",$total_sites->count)
                ->url(ViewAllSitesResource::getUrl()),



            Stat::make("Pending Orders",$pending_orders)
                ->url(OrderResource::getUrl()),
            Stat::make("Waiting Orders",$waiting_orders)
                ->url(OrderResource::getUrl()),
            Stat::make("Rejected Orders",$rejected_orders)
                ->url(OrderResource::getUrl()),
            Stat::make("Completed Orders",$completed_orders)
                ->url(OrderResource::getUrl()),


            Stat::make("Threads",Thread::where('owner_id', Auth::id())->orWhere('user_id',Auth::id())->count())
                ->icon("heroicon-o-chat-bubble-left-right")
                ->url(TicketResource::getUrl()),


        ];
    }
}
