<?php

namespace App\Filament\Blogger\Pages;

use App\Models\Country;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Notifications\Notification;
use Filament\Pages\Page;
use Illuminate\Support\Facades\Auth;

class UpdateProfile extends Page implements HasForms
{
    use InteractsWithForms;

    public ?array $data = [];

    public function mount(): void
    {
        $this->form->fill();
    }


    protected static bool $shouldRegisterNavigation = false;
    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.blogger.pages.update-profile';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make("Update Profile")->description("Update your profile information")
                    ->schema([

                    TextInput::make('name')
                        ->default(function (){
                            return Auth::user()->name;
                        })
                        ->inlineLabel()->required(),

                    Select::make("country_id")
                        ->required()
                        ->default(Auth::user()->country_id)
                        ->options(Country::orderBy('name','asc')->pluck("name","id"))
                        ->inlineLabel(),
                    TextInput::make('whatsapp')->default(Auth::user()->whatsapp)->inlineLabel()->required(),
                    TextInput::make('skype')->default(Auth::user()->skype)->inlineLabel()->required(),
                    TextInput::make('address')->default(Auth::user()->address)->inlineLabel()->required(),
                    Section::make("For Indian Users")->schema([
                        TextInput::make('aadhar_number')->default(Auth::user()->aadhar_number)->inlineLabel(),
                        TextInput::make('pancard_number')->default(Auth::user()->pancard_number)->inlineLabel(),
                        TextInput::make('gst_number')->default(Auth::user()->gst_number)->inlineLabel(),
                    ])->hidden(function (){
                        if( Auth::user()->country_id == 1 ){
                            return false;
                        }
                        return true;
                    }),
                    FileUpload::make("profile_image")
                        ->default(Auth::user()->profile_image)
                        ->label("Profile Image")
                        ->directory("uploads")
                        ->image(),

                ])
                    ->columnSpan(1),
            ])->columns(2)
            ->statePath('data');
    }

    public function create(): void
    {
        $data = $this->form->getState();

        try{
            if( Auth::user()->country_id == 1 ){
                Auth::user()->update([
                    "name"  => $data['name'],
                    "country_id"    => $data['country_id'],
                    "address"    => $data['address'],
                    "whatsapp"  => $data['whatsapp'],
                    "aadhar_number"  => $data['aadhar_number'],
                    "pancard_number"  => $data['pancard_number'],
                    "gst_number"  => $data['gst_number'],
                    "skype"  => $data['skype'],
                    "profile_image" => $data['profile_image']
                ]);
            }else{
                Auth::user()->update([
                    "name"  => $data['name'],
                    "address"    => $data['address'],
                    "country_id"    => $data['country_id'],
                    "whatsapp"  => $data['whatsapp'],

                    "skype"  => $data['skype'],
                    "profile_image" => $data['profile_image']
                ]);
            }


            Notification::make("success")->title("Profile Updated")->success()->send();
            $this->redirect(Profile::getUrl());
        }catch (\Exception $exception){
            dd($exception->getMessage());
        }

    }

}
