<?php

namespace App\Filament\Blogger\Pages;

use App\Filament\Blogger\Resources\ViewAllSitesResource;
use App\Models\NewSite;
use Filament\Forms\Components\CheckboxList;
use Filament\Forms\Components\Hidden;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Forms\Get;
use Filament\Forms\Set;
use Filament\Notifications\Notification;
use Filament\Pages\Page;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use PHPUnit\Exception;

class SingleSite extends Page implements HasForms
{
    use InteractsWithForms;
    public ?array $data = [];

    protected static ?string $navigationGroup = "Sites";
    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.blogger.pages.single-site';


    public function mount(): void
    {
        $this->form->fill([]);
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make("Domain Information")->schema([
                    TextInput::make("root_domain")->required(),
                    Select::make("category")
                        ->required()
                        ->searchable()
                        ->options([
                            "Automobiles" => "Automobiles",
                            "Animals and pets" => "Animals and pets",
                            "Adult Relationships and Sex" => "Adult Relationships and Sex",
                            "Agriculture & Farming" => "Agriculture & Farming",
                            "Aviation and Flight" => "Aviation and Flight",
                            "Architecture and Design" => "Architecture and Design",
                            "Arts" => "Arts",
                            "Banking and Financial" => "Banking and Financial",
                            "Beauty and Cosmetics" => "Beauty and Cosmetics",
                            "Books and Author" => "Books and Author",
                            "Business and Entrepreneurship" => "Business and Entrepreneurship",
                            "Career and Employment" => "Career and Employment",
                            "Construction and Repairs" => "Construction and Repairs",
                            "CBD Casino Betting and Gambling" => "CBD Casino Betting and Gambling",
                            "Computers and Electronics" => "Computers and Electronics",
                            "Cryptocurrency and Bitcoin" => "Cryptocurrency and Bitcoin",
                            "Culture and Tradition" => "Culture and Tradition",
                            "Design and Web Development" => "Design and Web Development",
                            "Digital Marketing SEO and Advertising" => "Digital Marketing SEO and Advertising",
                            "Environment" => "Environment",
                            "E-commerce and Shopping" => "E-commerce and Shopping",
                            "Education" => "Education",
                            "Entertainment Music Movies and Recreation" => "Entertainment Music Movies and Recreation",
                            "Fashion and lifestyle" => "Fashion and lifestyle",
                            "Finance and Investing" => "Finance and Investing",
                            "Food and Cuisine" => "Food and Cuisine",
                            "Family and Parenting Child" => "Family and Parenting Child",
                            "Gadgets" => "Gadgets",
                            "Games" => "Games",
                            "General Blog" => "General Blog",
                            "Gardening" => "Gardening",
                            "Green Energy & Technology" => "Green Energy & Technology",
                            "Hardware and Development" => "Hardware and Development",
                            "Humor" => "Humor",
                            "Home Improvement and Decor" => "Home Improvement and Decor",
                            "Health and Fitness" => "Health and Fitness",
                            "Home Appliances" => "Home Appliances",
                            "Industry and  Company" => "Industry and  Company",
                            "Insurance & Investment" => "Insurance & Investment",
                            "Internet Data & Cyber Law" => "Internet Data & Cyber Law",
                            "Job Career" => "Job Career",
                            "Leisure and Hobbies" => "Leisure and Hobbies",
                            "Literature" => "Literature",
                            "Love and Dating Relationships" => "Love and Dating Relationships",
                            "Legal and law" => "Legal and law",
                            "Manufacturing Machinery and Equipment" => "Manufacturing Machinery and Equipment",
                            "Marketing" => "Marketing",
                            "Medical" => "Medical",
                            "Metallurgy" => "Metallurgy",
                            "Miscellaneous" => "Miscellaneous",
                            "Make Money" => "Make Money",
                            "Movers and Packers" => "Movers and Packers",
                            "Nature" => "Nature",
                            "News and Media Updates" => "News and Media Updates",
                            "Personal Blogs" => "Personal Blogs",
                            "Places" => "Places",
                            "Politics" => "Politics",
                            "Programming" => "Programming",
                            "Public Service" => "Public Service",
                            "Product Reviews" => "Product Reviews",
                            "Photography and Wedding" => "Photography and Wedding",
                            "Parenting Baby and Moms" => "Parenting Baby and Moms",
                            "PR Banking" => "PR Banking",
                            "Real Estate and Homes" => "Real Estate and Homes",
                            "Religion" => "Religion",
                            "Science" => "Science",
                            "Society" => "Society",
                            "Startups" => "Startups",
                            "Security" => "Security",
                            "Society and Enforcements" => "Society and Enforcements",
                            "Software development Apps Saas and Tools" => "Software development Apps Saas and Tools",
                            "Sports and Games" => "Sports and Games",
                            "Social Media" => "Social Media",
                            "Senior Living" => "Senior Living",
                            "Technology" => "Technology",
                            "Telecommunication" => "Telecommunication",
                            "Travel and Tourism" => "Travel and Tourism",
                            "Trade and Commerce" => "Trade and Commerce",
                            "Transportation" => "Transportation",
                            "Writing and Tools Essay"=>"Writing and Tools Essay"
                        ])
                    ,

                    Select::make("traffic_source")
                        ->required()
                        ->searchable()
                        ->options([
                            "UK" => "UK",
                            "USA" => "USA",
                            "CANADA" => "CANADA",
                            "AUSTRALIA" => "AUSTRALIA",
                            "INDIA" => "INDIA",
                            "DUBAI" => "DUBAI",
                            "NEWZEALAND" => "NEWZEALAND",
                            "AUSTRIA" => "AUSTRIA"
                        ]),
                    TextInput::make("spam_score")->numeric()->required(),
                    TextInput::make("sample_url")->url(),
                    Select::make("total_time")->required()->options([
                        "24"    =>  "24 Hours",
                        "48"    =>  "48 Hours",
                        "72"    =>  "72 Hours",
                    ])

                ])->columns(4),

                Section::make("Link Information")->schema([
                    Select::make("marked_sponsor")->required()->options([
                        "Yes"    =>  "Yes",
                        "No"    =>  "No",
                    ]),

                    Select::make("accept_grey_niche")
                        ->required()
                        ->live()
                        ->options([
                        "Yes"    =>  "Yes",
                        "No"    =>  "No",
                    ]),

                    CheckboxList::make("grey_niche_types")->options([
                        "Adult" => "Adult",
                        "CBD"   =>  "CBD",
                        "Gambling"    =>  "Gambling",
                        "Gaming"    =>  "Gaming",
                        "Vaping"    =>  "Vaping",
                     ])
                        ->columnSpan(2)
                        ->columns(5)
                        ->hidden(function (Get $get) {
                            if($get('accept_grey_niche') == 'Yes'){
                                return false;
                            }
                            return true;
                        })


                ])->columns(4),


                Section::make("SEO Metrics")->schema([
                    TextInput::make("da")->label("DA")->required()->numeric()->inlineLabel(),
                    TextInput::make("dr")->label("DR")->required()->numeric()->inlineLabel(),
                    TextInput::make("traffic")->label("Traffic")->required()->numeric()->inlineLabel(),
                    TextInput::make("gp_price")
                        ->live(onBlur: true)
                        ->label("GP Price (USD)")
                        ->numeric()
                        ->inlineLabel()
                        ->required()
                        ->afterStateUpdated(function (Set $set, Get $get) {
                            $traffic = $get('traffic');
                            $gp_price  = $get('gp_price');
                            if(empty($traffic)){
                                Notification::make("error")->title("The traffic field is required")->danger()->send();
                            }else{
                                $traffic = (double) $traffic;
                                $gp_price = (double) $gp_price;
                                $q= DB::table("price_charts")
                                    ->whereRaw("traffic_start_range <= ".$traffic." and traffic_end_range > ".$traffic." " )
                                    ->first();

                                if( $gp_price > $q->gp_end_range ){
                                    Notification::make("error")->title("Please lower your gp price. It does not meet our pricing criteria")->danger()->send();
                                }

                            }
                        })
                    ,
                    TextInput::make("rd")->label("RD")->required()->numeric()->inlineLabel(),
                    TextInput::make("niche_edit_price")
                        ->live(onBlur: true)
                        ->label("Niche Edit Price (USD)")
                        ->numeric()
                        ->inlineLabel()
                        ->required()
                        ->afterStateUpdated(function (Set $set, Get $get) {
                            $rd = $get('rd');
                            $niche_edit_price  = $get('niche_edit_price');
                            if(empty($rd)){
                                Notification::make("error")->title("The RD field is required")->danger()->send();
                            }else{
                                $rd = (double) $rd;
                                $niche_edit_price = (double) $niche_edit_price;

                                $query= DB::table("price_charts")
                                    ->whereRaw("rd_start_range <= ".$rd." and rd_end_range > ".$rd." " )
                                    ->first();

                                if( $niche_edit_price > $query->niche_end_range ){
                                    Notification::make("error")->title("Please lower your niche edit price. It does not meet our pricing criteria")->danger()->send();
                                }

                            }
                        })
                    ,
                    TextInput::make("fc_gp")->label("FC GP")->required()->numeric()->inlineLabel(),
                    TextInput::make("fc_ne")->label("FC NE")->required()->numeric()->inlineLabel(),
                ])->columns(2),



            ])
            ->statePath('data');
    }

    public function create(): void
    {
        $data = $this->form->getState();


        try{

            $traffic = (double) $data['traffic'];
            $gp_price = (double) $data['gp_price'];
            $q= DB::table("price_charts")
                ->whereRaw("traffic_start_range <= ".$traffic." and traffic_end_range > ".$traffic." " )
                ->first();

            if( $gp_price > $q->gp_end_range ){
                Notification::make("error")->title("Please lower your gp price. It does not meet our pricing criteria")->danger()->send();
            }else{
                $rd = (double) $data['rd'];
                $niche_edit_price = (double) $data['niche_edit_price'];

                $query= DB::table("price_charts")
                    ->whereRaw("rd_start_range <= ".$rd." and rd_end_range > ".$rd." " )
                    ->first();

                if( $niche_edit_price > $query->niche_end_range ){
                    Notification::make("error")->title("Please lower your niche edit price. It does not meet our pricing criteria")->danger()->send();
                }else{

                    $new_site= new NewSite();

                    $new_site->uploaded_user_id= Auth::id();

//            $new_site->association_type= $data['association_type'];
//            $new_site->domain_type= $data['domain_type'];
                    $new_site->root_domain= $data['root_domain'];
//            $new_site->niche= $data['niche'];
                    $new_site->category= $data['category'];
                    $new_site->country_source= $data['traffic_source'];
                    $new_site->spam_score= $data['spam_score'];
                    $new_site->sample_url= $data['sample_url'];
                    $new_site->total_time= $data['total_time'];

                    $new_site->marked_sponsor= $data['marked_sponsor'];
//            $new_site->link_type= $data['link_type'];
//            $new_site->link_validity= $data['link_validity'];
                    $new_site->accept_grey_niche= $data['accept_grey_niche'];
                    if(isset($data['grey_niche_types'])) {
                        $new_site->grey_niche_types = implode(",", $data['grey_niche_types']);
                    }

                    $new_site->da= $data['da'];
                    $new_site->dr= $data['dr'];
                    $new_site->traffic_source= $data['traffic'];
                    $new_site->gp_price= $data['gp_price'];
                    $new_site->niche_edit_price= $data['niche_edit_price'];
                    $new_site->rd= $data['rd'];
                    $new_site->fc_gp= $data['fc_gp'];
                    $new_site->fc_ne= $data['fc_ne'];

                    $new_site->site_status = 0 ;
                    $new_site->source = "Website";

                    $new_site->save();



                    Notification::make("success")->title("Site Added")->send();

                    $this->redirect(ViewAllSitesResource::getUrl());

                }
            }




        }catch (Exception $exception){
            session()->flash("error",$exception->getMessage());
        }
    }
}
