<?php

namespace App\Filament\Blogger\Pages;

use App\Filament\Blogger\Resources\WalletResource;
use App\Models\User;
use App\Models\WalletHistory;
use App\Models\WithdrawRequest;
use Carbon\Carbon;
use Filament\Forms\Components\CheckboxList;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\Radio;
use Filament\Forms\Components\Section;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Forms\Get;
use Filament\Notifications\Notification;
use Filament\Pages\Page;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\HtmlString;

class RequestWithdrawal extends Page implements HasForms, HasTable
{
    use InteractsWithForms;
    use InteractsWithTable;

    public $histories;

    public ?array $data = [];

    public function mount(): void
    {
        if(!Auth::user()->country){
            Notification::make("error")->title("Please Complete your profile")->send();
            $this->redirect(Profile::getUrl());
        }

        $this->form->fill();

    }

    public function render(): View
    {
        $this->histories=  WalletHistory::with("new_order_process_detail.new_order_process.new_order")->whereHas('wallet',function ($q){
            $q->where('user_id',Auth::id());
        })->where('status',null)->where('request_date',null)->where('approved_date',null)->get();
        return parent::render(); // TODO: Change the autogenerated stub
    }


    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static bool $shouldRegisterNavigation = false;

    protected static string $view = 'filament.blogger.pages.request-withdrawal';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make("Withdraw Request")->label("Withdraw Request")->schema([
                    CheckboxList::make("order_ids")
                        ->required()
                        ->live()
                        ->label("Select Orders")
                        ->options(function (){
                            $arr = [];
                            foreach ($this->histories as $item) {
                                $arr[$item['id']] = $item->new_order_process_detail->new_order_process->new_order->order_id.' (Amount:- '.$item->price.')';
                            }

                            return $arr;
                        })
                        ->descriptions(function (){
                            $histories=  WalletHistory::with("new_order_process_detail.new_order_process.new_order")->whereHas('wallet',function ($q){
                                $q->where('user_id',Auth::id());
                            })->where('status',null)->where('request_date',null)->where('approved_date',null)->get();
                            $arr = [];
                            foreach ($histories as $item) {
//                                $arr[$item['id']] = str("**URL:-** ".$item->new_order_process_detail->submit_url)->inlineMarkdown()->toHtmlString();
                                $arr[$item['id']] = new HtmlString("<span style='display: flex;flex-direction:column;justify-content: space-between;width: 100%;margin-top: 3px;'>
                                            <span><strong>URL:-</strong>".$item->new_order_process_detail->submit_url."</span>
                                            <span><strong>Date:-</strong>".Carbon::parse($item->created_at)->toDayDateTimeString()."</span>

                                            </span>");
                            }

                            return $arr;
                        }),
                    Placeholder::make("total")->label("Total Amount")->content(function (Get $get){
                        $ids= $get('order_ids');
                        $sum = WalletHistory::selectRaw("SUM(price) as count")->whereHas('wallet',function ($q){
                            $q->where('user_id',Auth::id());
                        })->where('status',null)->where('request_date',null)->where('approved_date',null)
                            ->whereIn("id",$ids)
                            ->first()->count;
//                        Log::info("Sum ".$sum);
                        return $sum ?? 0;
                    })->inlineLabel(),

                    Radio::make("payment_method")
                        ->label("Select Payment Method")
                        ->inline()
                        ->live()
                        ->required()
                        ->options(function (){
                            $arr = [];
                            if(in_array("bank",json_decode(Auth::user()->country->payment_methods))){
                                $arr["bank"] = "Bank";
                            }

                            if(in_array("paypal",json_decode(Auth::user()->country->payment_methods))){
                                $arr["paypal_id"] = "Paypal ID";
                            }

                            if(in_array("qr_code",json_decode(Auth::user()->country->payment_methods))){
                                $arr["qr_code"] = "Qr Code";
                            }

                            if(in_array("upi_id",json_decode(Auth::user()->country->payment_methods))){
                                $arr["upi_id"] = "UPI ID";
                            }



                            return $arr;
                        }),


                    Placeholder::make("selected_payment_method")
                        ->inlineLabel()
                        ->label(" ")->content(function (Get $get){
                            $payment_method = $get('payment_method');
                            if($payment_method == 'paypal_id'){
                                return new HtmlString("<strong>Paypal ID:-</strong> ".Auth::user()->paypal_email);
                            }

                            if($payment_method == 'bank'){
                                $text = "<table>";
                                $text .=  "<tr><th style='text-align: left;padding:5px;border-bottom: 1px solid black'>Account Type:-</th> <td style='text-align: left;padding:5px;border-bottom: 1px solid black'>" . Auth::user()->bank_type.'</td></tr>';
                                $text .= "<tr><th style='text-align: left;padding:5px;border-bottom: 1px solid black'>Beneficiary Account Number</th> <td style='text-align: left;padding:5px;border-bottom: 1px solid black'> ".Auth::user()->beneficiary_account_number.'</td></tr>';
                                $text .= "<tr><th style='text-align: left;padding:5px;border-bottom: 1px solid black'>Beneficiary Name</th> <td style='text-align: left;padding:5px;border-bottom: 1px solid black'> ".Auth::user()->beneficiary_name.'</td></tr>';
                                $text .= "<tr><th style='text-align: left;padding:5px;border-bottom: 1px solid black'>Bank Name</th> <td style='text-align: left;padding:5px;border-bottom: 1px solid black'> ".Auth::user()->bene_bank_name.'</td></tr>';
                                $text .= "<tr><th style='text-align: left;padding:5px;border-bottom: 1px solid black'>IFSC Code</th> <td style='text-align: left;padding:5px;border-bottom: 1px solid black'> ".Auth::user()->ifsc_code.'</td></tr>';

                                $text .= "<tr><th style='text-align: left;padding:5px;border-bottom: 1px solid black'>Bank Branch Name</th> <td style='text-align: left;padding:5px;border-bottom: 1px solid black'> ".Auth::user()->bene_bank_branch_name.'</td></tr>';
                                $text .= "<tr><th style='text-align: left;padding:5px;border-bottom: 1px solid black'>Beneficiary Email id</th> <td style='text-align: left;padding:5px;border-bottom: 1px solid black'> ".Auth::user()->beneficiary_email_id.'</td></tr>';
                                $text .= "<tr><th style='text-align: left;padding:5px;border-bottom: 1px solid black'>Customer Reference Number</th> <td style='text-align: left;padding:5px;border-bottom: 1px solid black'> ".Auth::user()->customer_reference_number.'</td></tr>';
                                $text .= "</table>";
                                return new HtmlString($text);
                            }

                            if($payment_method == 'upi_id'){

                                $text = "<table>";
                                $text .= "<tr><th style='text-align: left;padding:5px;border-bottom: 1px solid black'>UPI Id:-</th> <td style='text-align: left;padding:5px;border-bottom: 1px solid black'> ".Auth::user()->upi_id.'</td></tr>';
                                $text .=  "<tr><th style='text-align: left;padding:5px;border-bottom: 1px solid black'>Account Type:-</th> <td style='text-align: left;padding:5px;border-bottom: 1px solid black'>" . Auth::user()->bank_type.'</td></tr>';
                                $text .= "<tr><th style='text-align: left;padding:5px;border-bottom: 1px solid black'>Beneficiary Account Number</th> <td style='text-align: left;padding:5px;border-bottom: 1px solid black'> ".Auth::user()->beneficiary_account_number.'</td></tr>';
                                $text .= "<tr><th style='text-align: left;padding:5px;border-bottom: 1px solid black'>Beneficiary Name</th> <td style='text-align: left;padding:5px;border-bottom: 1px solid black'> ".Auth::user()->beneficiary_name.'</td></tr>';
                                $text .= "<tr><th style='text-align: left;padding:5px;border-bottom: 1px solid black'>Bank Name</th> <td style='text-align: left;padding:5px;border-bottom: 1px solid black'> ".Auth::user()->bene_bank_name.'</td></tr>';
                                $text .= "<tr><th style='text-align: left;padding:5px;border-bottom: 1px solid black'>IFSC Code</th> <td style='text-align: left;padding:5px;border-bottom: 1px solid black'> ".Auth::user()->ifsc_code.'</td></tr>';

                                $text .= "<tr><th style='text-align: left;padding:5px;border-bottom: 1px solid black'>Bank Branch Name</th> <td style='text-align: left;padding:5px;border-bottom: 1px solid black'> ".Auth::user()->bene_bank_branch_name.'</td></tr>';
                                $text .= "<tr><th style='text-align: left;padding:5px;border-bottom: 1px solid black'>Beneficiary Email id</th> <td style='text-align: left;padding:5px;border-bottom: 1px solid black'> ".Auth::user()->beneficiary_email_id.'</td></tr>';
                                $text .= "<tr><th style='text-align: left;padding:5px;border-bottom: 1px solid black'>Customer Reference Number</th> <td style='text-align: left;padding:5px;border-bottom: 1px solid black'> ".Auth::user()->customer_reference_number.'</td></tr>';
                                $text .= "</table>";
                                return new HtmlString($text);
                            }

                            if($payment_method == 'qr_code'){
                                if(Auth::user()->qr_code_image) {
                                    return new HtmlString("<img src='/". Auth::user()->qr_code_image . "' style='width:300px;'>");
                                }
                                return '';
                            }



                            return  'Selected Payment Method';
                        })




                ])
            ])
            ->statePath('data');
    }

    public function create(): void
    {

        $data = $this->form->getState();
        $payment_method = $data['payment_method'];
        $selected_bills =  $data['order_ids'];

        if($payment_method == 'bank'){
            if(
                Auth::user()->bank_type == null ||
                Auth::user()->beneficiary_name == null ||
                Auth::user()->beneficiary_account_number == null ||
                Auth::user()->customer_reference_number == null ||
                Auth::user()->bene_bank_name == null ||
                Auth::user()->bene_bank_branch_name == null ||
                Auth::user()->beneficiary_email_id == null ||
                Auth::user()->ifsc_code == null
            ){
                Notification::make("danger")->title("Please Update Your Bank Details")->send();
                return ;
            }
        }
        elseif ($payment_method == 'paypal_id'){
            if(Auth::user()->paypal_email == null ){
                Notification::make("danger")->title("Paypal Id is missing")->send();
                return ;
            }
        }elseif ($payment_method == 'qr_code'){
            if(Auth::user()->qr_code_image == null ){
                Notification::make("danger")->title("QR Code is missing")->send();
                return ;
            }
        }elseif ($payment_method == 'upi_id'){
            if(Auth::user()->upi_id == null ||
                Auth::user()->bank_type == null ||
                Auth::user()->beneficiary_name == null ||
                Auth::user()->beneficiary_account_number == null ||
                Auth::user()->customer_reference_number == null ||
                Auth::user()->bene_bank_name == null ||
                Auth::user()->bene_bank_branch_name == null ||
                Auth::user()->beneficiary_email_id == null ||
                Auth::user()->ifsc_code == null
            ){
                Notification::make("danger")->title("UPI ID is missing or Bank Details are missing")->send();
                return ;
            }
        }


        try{




            DB::beginTransaction();


            $withdraw_request = new WithdrawRequest();
            $withdraw_request->user_id = Auth::id();
            $withdraw_request->status = 0;
            $last_invoice_number = WithdrawRequest::orderBy('id','desc')->first();
            $withdraw_request->invoice_number = $last_invoice_number->invoice_number + 1;
            $withdraw_request->invoice_pre = 'LM';
            $withdraw_request->save();
            foreach ($selected_bills as $bill) {
                $history = WalletHistory::whereHas('wallet', function ($q) {
                    $q->where('user_id', Auth::id());
                })->where('id', $bill)->firstOrFail();


                $history->payment_method = $payment_method;
                $history->request_date = Carbon::now();
                if ($payment_method == 'bank') {
                    $history->bank_type = Auth::user()->bank_type;
                    $history->beneficiary_name = Auth::user()->beneficiary_name;
                    $history->beneficiary_account_number = Auth::user()->beneficiary_account_number;
                    $history->customer_reference_number = Auth::user()->customer_reference_number;
                    $history->ifsc_code = Auth::user()->ifsc_code;
                    $history->bene_bank_name = Auth::user()->bene_bank_name;
                    $history->bene_bank_branch_name = Auth::user()->bene_bank_branch_name;
                    $history->beneficiary_email_id = Auth::user()->beneficiary_email_id;
                } elseif ($payment_method == 'paypal_id') {
                    $history->paypal_email = Auth::user()->paypal_email;
                } elseif ($payment_method == 'qr_code') {
                    $history->qr_code_image = Auth::user()->qr_code_image;
                } elseif ($payment_method == 'upi_id') {
                    $history->upi_id = Auth::user()->upi_id;
                }
                $history->status = 0;
                $history->withdraw_request_id = $withdraw_request->id;
                $history->save();
            }



            DB::commit();
            Notification::make("success")->title("Withdrawal Request Sent")->send();

            $admin = User::where('role','admin')->first();

            Notification::make()
                ->title("New Payment Request Withdrawal ")
                ->body("by ".Auth::user()->name.'('.Auth::user()->email.')')
                ->success()
                ->sendToDatabase([$admin]);


            $this->redirect(WalletResource::getUrl());
        }catch (\Exception $exception){
            DB::rollBack();
            dd($exception->getMessage());
        }



    }

    public function table(Table $table): Table
    {
        return $table
            ->query(
                WalletHistory::with("new_order_process_detail.new_order_process.new_order")->whereHas('wallet',function ($q){
                    $q->where('user_id',Auth::id());
                })->where('status',null)->where('request_date',null)->where('approved_date',null)
            )
            ->columns([
                TextColumn::make("created_at")->label("Date"),
                TextColumn::make("new_order_process_detail.new_order_process.new_order.order_id")
                    ->label("Order Id")
                    ->wrap()
                    ->description(function ($record) {
                        return $record->new_order_process_detail->submit_url;
                    }),
            ])
            ->filters([
                // ...
            ])
            ->actions([
                // ...
            ])
            ->bulkActions([
                // ...
            ]);
    }
}
