<?php

namespace App\Exports;

use App\Models\WithdrawRequest;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromView;

class WithdrawRequestExport implements FromView
{

    public function view(): View
    {
        $requests =  WithdrawRequest::has("wallet_histories")->with("wallet_histories")->withSum(['wallet_histories as total_price' => function ($query) {
            $query->select(DB::raw('SUM(price)'));
        }], 'price')->where('status',0)->get();
        return view("exports.withdraw_request",compact("requests"));
    }
}
