@php use Carbon\Carbon; @endphp
@extends("vendor.layouts.app")

@section("container")
    <div class="max-w-screen-2xl mx-auto px-8">
        <div class="bg-white shadow p-4">
            <h1 class="text-2xl font-semibold flex items-center justify-between">
                <div>Wallet Balance:- {{ vendor_balance() }}</div>

                <div>
                    <a class="text-xs bg-red-500 text-white px-6 py-2 rounded" href="{{ route("vendor.withdraw_request") }}">Withdrawal</a>
                </div>

            </h1>

            <div class="overflow-y-auto">
                <table class="table-fixed mt-6 ">
                <thead class="bg-gray-100 ">
                    <tr>
                        <th class="text-left py-3 px-4 text-sm" width="10%">Date</th>
                        <th class="text-left py-3 px-4" width="40%">Order Id</th>
                        <th class="text-left py-3 px-4">Remarks</th>
                        <th class="text-left py-3 px-4 text-sm">Credit</th>
                        <th class="text-left py-3 px-4 text-sm">Withdraw Status</th>
                        <th class="text-left py-3 px-4 text-sm">Approved Status</th>
                    </tr>
                </thead>
                @foreach($wallet_histories as $history)
                    <tr class="border-b border-gray-200">
                        <td class="py-3 px-4 text-xs text-left">{{ $history->created_at->toDayDateTimeString() }}</td>
                        <td class="py-3 px-4 text-xs text-left">
                            <div class="border-b border-gray-300 pb-1 mb-2">
                                {{ optional(optional(optional($history->new_order_process_detail)->new_order_process)->new_order)->order_id }}
                            </div>
                            <div class="flex items-center space-x-2">
                                <span class="font-black">URL:</span>
                                <span>{{ optional($history->new_order_process_detail)->submit_url }}</span>
                            </div>
{{--                            <div class="flex items-center space-x-2">--}}
{{--                                <span class="font-black">Remarks:</span>--}}
{{--                                <span></span>--}}
{{--                            </div>--}}
                        </td>
                        <td class="py-3 px-4 text-left text-sm" width="15%">{{ $history->remarks }}</td>
                        <td class="py-3 px-4 text-left">
                            <div class="flex flex-col">
                                <div>{{ $history->price }}</div>

                            </div>

                        </td>

                        <td class="py-3 px-4 text-left">
                            @if($history->status == 0 && $history->request_date )
                               <div class="flex items-center justify-between px-4">
                                   <span class="text-xs font-semibold">Status</span>
                                   <span class="bg-orange-500 text-white text-xs rounded px-3 py-1.5">Pending</span>
                               </div>

                                <div class="flex items-center justify-between px-4 mt-2">
                                    <span class="text-xs font-semibold">Date</span>
                                    <span class="bg-gray-700 text-white text-xs rounded px-3 py-1.5">
                                        {{ Carbon::parse($history->request_date)->toDayDateTimeString() }}
                                    </span>
                                </div>


                            @endif
{{--                            @if($history->status == 1 && $history->request_date )--}}
{{--                                <span class="bg-green-500 text-white text-xs rounded px-3 py-1.5">Approved</span>--}}
{{--                            @endif--}}
                        </td>

                        <td class="py-3 px-4 text-left">
                            @if($history->status == 1 && $history->approved_date )
                                <div class="flex items-center justify-between px-4">
                                    <span class="text-xs font-semibold">Status</span>
                                    <span class="bg-green-500 text-white text-xs rounded px-3 py-1.5">Approved</span>
                                </div>

                                <div class="flex items-center justify-between px-4 mt-2">
                                    <span class="text-xs font-semibold">Date</span>
                                    <span class="bg-gray-700 text-white text-xs rounded px-2 py-1" style="font-size: 9px;">
                                        {{ Carbon::parse($history->approved_date)->toDayDateTimeString() }}
                                    </span>
                                </div>


                            @endif


                        </td>
                    </tr>
                @endforeach
            </table>
            </div>


{{--            <table class="table-auto w-full mt-6">--}}
{{--                <thead class="bg-gray-100 ">--}}
{{--                    <tr>--}}
{{--                        <th class="text-left py-3 px-4">Date</th>--}}
{{--                        <th class="text-left py-3 px-4">Credit</th>--}}
{{--                        <th class="text-left py-3 px-4">Debit</th>--}}
{{--                        <th class="text-left py-3 px-4">Balance</th>--}}
{{--                        <th class="text-left py-3 px-4">Status</th>--}}
{{--                        <th class="text-left py-3 px-4">Remarks</th>--}}
{{--                        <th class="text-left py-3 px-4">Order Id</th>--}}
{{--                    </tr>--}}
{{--                </thead>--}}
{{--                @php $bal = 0; @endphp--}}
{{--                @foreach($wallet_histories as $history)--}}
{{--                    <tr class="border-b border-gray-200">--}}
{{--                        <td class="py-3 px-4 text-xs">{{ $history->created_at->toDayDateTimeString() }}</td>--}}
{{--                        <td class="py-3 px-4"> @if($history->type == 'credit') {{ $history->price }} @endif </td>--}}
{{--                        <td class="py-3 px-4"> @if($history->type == 'debit') {{ $history->price }} @endif </td>--}}
{{--                        <td class="py-3 px-4">--}}
{{--                            @if($loop->index == 0)--}}
{{--                                @php--}}
{{--                                    $bal = $history->price;--}}
{{--                                @endphp--}}
{{--                                {{ $bal }}--}}
{{--                            @else--}}
{{--                                @php--}}
{{--                                    $bal =( $history->type == 'credit' ) ? $bal + $history->price : $bal - $history->price;--}}
{{--                                @endphp--}}
{{--                                {{ $bal }}--}}
{{--                            @endif--}}

{{--                        </td>--}}
{{--                        <td class="py-3 px-4">--}}
{{--                            @if($history->status == 0 && $history->type == 'debit' )--}}
{{--                                <span class="bg-orange-500 text-white text-xs rounded px-3 py-1.5">Pending</span>--}}
{{--                            @endif--}}
{{--                            @if($history->status == 1 && $history->type == 'debit' )--}}
{{--                                <span class="bg-green-500 text-white text-xs rounded px-3 py-1.5">Approved</span>--}}

{{--                            @endif--}}
{{--                        </td>--}}
{{--                        <td class="py-3 px-4">--}}

{{--                            @if($history->status == 1 && $history->type == 'debit' )--}}
{{--                                <div class="text-xs text-gray-800 mt-2">--}}
{{--                                    {{ $history->remarks }}--}}
{{--                                </div>--}}
{{--                            @endif--}}
{{--                        </td>--}}
{{--                        <td class="py-3 px-4">--}}
{{--                            @if($history->type == 'credit')--}}
{{--                                {{ optional(optional(optional($history->new_order_process_detail)->new_order_process)->new_order)->order_id }}--}}
{{--                            @endif--}}
{{--                        </td>--}}
{{--                    </tr>--}}
{{--                @endforeach--}}
{{--            </table>--}}

        </div>
    </div>
@endsection
