@extends("vendor.layouts.app")

@section("container")
    <div class="max-w-screen-xl mx-auto bg-white mt-4 p-4">
        <h1 class="bg-gray-200 p-3">Site</h1>

        <div class="grid grid-cols-3 gap-4 mt-4">
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">Associate Type</span>
                <span class="text-xs">{{ $record->association_type }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">Domain Type:</span>
                <span class="text-xs">{{ $record->domain_type }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">Domain Name:</span>
                <span class="text-xs">{{ $record->root_domain }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">Niche Type:</span>
                <span class="text-xs">{{ $record->niche }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">Categories</span>
                <span class="text-xs">{{ $record->category }}</span>
            </div>



            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">Traffic Source</span>
                <span class="text-xs">{{ $record->traffic_source }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">Grey Niche</span>
                <span class="text-xs">{{ $record->accept_grey_niche }}</span>
            </div>

            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">Grey Niche Type</span>
                <span class="text-xs">{{ $record->grey_niche_types }}</span>
            </div>

            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">Spam Score</span>
                <span class="text-xs">{{ $record->spam_score }}</span>
            </div>

            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">Word Count</span>
                <span class="text-xs">{{ $record->word_count }}</span>
            </div>


            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">Sample URL</span>
                <span class="text-xs">{{ $record->sample_url }}</span>
            </div>


            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">Sponsor</span>
                <span class="text-xs">{{ $record->marked_sponsor }}</span>
            </div>


            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">Link Type:</span>
                <span class="text-xs">{{ $record->link_type }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">Validity Type</span>
                <span class="text-xs">{{ $record->link_validity }}</span>
            </div>

            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">DA</span>
                <span class="text-xs">{{ $record->da }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">DR</span>
                <span class="text-xs">{{ $record->dr }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">Traffic</span>
                <span class="text-xs">{{ $record->traffic }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">GP Price</span>
                <span class="text-xs">{{ $record->gp_price }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">RD</span>
                <span class="text-xs">{{ $record->rd }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-blue-500 font-bold text-xs">Niche Price</span>
                <span class="text-xs">{{ $record->niche_edit_price }}</span>
            </div>






        </div>
    </div>
@endsection
