@extends("vendor.layouts.app")

@section("container")
    <div class="py-4">
        <div class="mx-auto max-w-screen-2xl px-8 grid grid-cols-12 gap-8">
            <main class="col-span-12 bg-white shadow-lg p-4">
                <div>
                    <h2 class="text-gray-800 font-bold text-lg">What is verification?</h2>
                    <div class="text-gray-700 mt-1 text-sm">
                        Verification is the process of proving that you own the site that you claim to own.We need to confirm ownership because once you are verified
                        for a site,you get access to its tasks.
                    </div>

                    <div class="p-4">
                        <div class="text-gray-600 text-sm mt-3">1. Edit the head of your index page or template</div>
                        <div class="text-gray-600 text-sm mt-3">2. Copy the below meta tag and put it inside the <span class="text-red-600">{{ "<head>" }}</span> tag of https://thrillgolf.com </div>
                        <div class="bg-gray-200 text-gray-500 border border-gray-400 text-xs p-4 my-4 ml-5">
                            {{ '<meta name="bm-site-verification" content="80349118a65236f539e215a5e79355d84f933142">' }}
                        </div>
                        <div class="text-gray-600 text-sm mt-3">
                            3. Save the page or template and clear the cahce if caching is on
                        </div>
                        <div class="text-gray-600 text-sm mt-3">
                            4. Press verify below
                        </div>
                        <div class="bg-green-200 text-green-700 border border-green-400 text-xs p-4 my-4 ml-5 tracking-wider">
                            Note:CDN(if used)may needs some time to update.If BlogManagement doesn't find the meta tag immediately,wait for a few hours and then try to
                            verify again.
                        </div>

                        <div class="flex items-center justify-center">
                            <button class="bg-blue-800 text-white px-5 py-2">Verify</button>
                        </div>

                    </div>

                </div>
            </main>
        </div>
    </div>
@endsection






