@extends("vendor.dashboard.new_design")

@section("container")
    <div class="max-w-screen-2xl mx-auto px-8">
        <div class="bg-white shadow mt-4 p-4">



                    @if(count($bulk_upload_status) > 0)
                       <div class="w-2/3">
                           @foreach($bulk_upload_status as $status)
                               <table class="w-full border-collapse  table-fixed border border-slate-300">
                                   <thead>
                                       <tr>
                                           <th class="p-3 border border-slate-300 bg-slate-200">Uploaded Date Time</th>
                                           <td class="p-3 border border-slate-300">{{ Carbon\Carbon::parse($status->created_at)->toDayDateTimeString() }}</td>
                                       </tr>
                                       <tr>
                                           <th class="p-3 border border-slate-300 bg-slate-200">Status</th>
                                           <td class="p-3 border border-slate-300">
                                               @if($status->status == 0 )
                                                   <div class="bg-red-500 text-white p-1 px-2 text-sm">Waiting for Admin Approval</div>
                                               @endif

                                               @if($status->status == 1 )
                                                   <div class="bg-orange-500 text-white p-1 px-2 text-sm">
                                                       Admin Approved and Uploaded your sites. Now check uploaded sites to accept or decline
                                                   </div>
                                               @endif

                                           </td>
                                       </tr>
                                       @if($status->status == 1 )
                                           <tr>
                                               <th class="p-3 border border-slate-300 bg-slate-200">View Sites</th>
                                               <td class="p-3 border border-slate-300">
                                                   <a class="text-blue-700 underline text-sm" href="{{ route("vendor.uploaded_sites",$status->id) }}">Click to view uploaded sites</a>
                                               </td>
                                           </tr>
                                       @endif
                                   </thead>
                               </table>
                           @endforeach
                       </div>
                    @else
                        <div class="grid grid-cols-2">
                            <div>
                                <p>First Download this <a href="/excel/new_site_format.xlsx" class="text-blue-700 underline">Excel File</a></p>
                                <form action="{{ route("vendor.upload_excel") }}" method="POST" enctype="multipart/form-data" class="mt-8">
                                    @csrf
                                    <div class="grid grid-cols-1 gap-6">
                                        <div>
                                            <div class="flex items-center">
                                                <label class="label-h-class w-2/5 text-right pr-8">Upload Excel File</label>
                                                <input type="file" autofocus class="textbox-class focus:ring-blue-500 focus:border-blue-500" name="upload_excel" >
                                            </div>
                                            @error('upload_excel')
                                            <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="flex justify-end items-end">
                                            <button type="submit" class="bg-gray-800 text-white text-lg rounded px-4 py-2">Import Excel File</button>
                                        </div>
                                    </div>
                                </form>
                            </div>

                        </div>
                    @endif

        </div>
    </div>
@endsection
