@extends("vendor.layouts.app")

@section("container")
    <div class="max-w-screen-xl mx-auto bg-white mt-4 p-4">
        <h1 class="bg-gray-200 p-3">Site</h1>

        <div class="grid grid-cols-3 gap-4 mt-4">
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-pink-700 font-bold text-xs">Associate Type</span>
                <span class="text-xs">{{ $record->associate_type }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-pink-700 font-bold text-xs">Domain Type:</span>
                <span class="text-xs">{{ $record->domain_type }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-pink-700 font-bold text-xs">Domain Name:</span>
                <span class="text-xs">{{ $record->domain_name }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-pink-700 font-bold text-xs">Niche Type:</span>
                <span class="text-xs">{{ $record->niche_type }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-pink-700 font-bold text-xs">Categories</span>
                <span class="text-xs">{{ $record->category_type }}</span>
            </div>



            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-pink-700 font-bold text-xs">Traffic Source</span>
                <span class="text-xs">{{ $record->traffic_source }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-pink-700 font-bold text-xs">Grey Niche</span>
                <span class="text-xs">{{ $record->grey_niche_type }}</span>
            </div>

            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-pink-700 font-bold text-xs">Grey Niche Type</span>
                <span class="text-xs">{{ $record->grey_niche }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-pink-700 font-bold text-xs">Sponsor</span>
                <span class="text-xs">{{ $record->sponsor_type }}</span>
            </div>


            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-pink-700 font-bold text-xs">Link Type:</span>
                <span class="text-xs">{{ $record->link_type }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-pink-700 font-bold text-xs">Validity Type</span>
                <span class="text-xs">{{ $record->validity_type }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-pink-700 font-bold text-xs">No of Links</span>
                <span class="text-xs">{{ $record->no_of_links }}</span>
            </div>
            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-pink-700 font-bold text-xs">Submission Date</span>
                <span class="text-xs">{{ Carbon\Carbon::parse($record->site_created)->toDateTimeString() }}</span>
            </div>

            <div class="flex items-center justify-between p-3 border border-gray-200">
                <span class="text-pink-700 font-bold text-xs">Status</span>
                <span class="text-xs">
                                <div class="bg-green-700 text-white px-3 py-1 rounded">
                            Approved
                        </div>
                            </span>
            </div>

        </div>
    </div>
@endsection
