@php use App\Project\NewOrderStatus;use Carbon\Carbon; @endphp
@extends("vendor.layouts.app")

@section("container")

    @if(  $detail->status == NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED ||
            $detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION ||
            $detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS
            )
        <div class="bg-white max-w-screen-xl mx-auto mt-4 shadow px-5 p-3 pt-6">


            <div class="bg-yellow-100 mb-4">
                <table class="w-full table-auto text-sm border border-separate border-gray-200">
                    <thead>
                    <tr>
                        <th class="w-48 p-3 border border-gray-300">Status</th>
                        <td class="p-3 border border-gray-300">
                            @if($detail->status == NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED)
                                <div style="background: blue;color: white;padding:8px;">Completed</div>
                            @endif

                            @if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION)
                                <div style="background: red;color: white;padding:8px;">Blogger Rejected the Order</div>
                            @endif

                            @if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS)
                                <div style="background: blue;color: white;padding:8px;">Waiting From Manager</div>
                            @endif

                        </td>
                    </tr>
                    <tr>
                        <th class="w-48 p-3 border border-gray-300">Order No.</th>
                        <td class="p-3 border border-gray-300">{{ $detail->new_order_process->new_order->order_id }} @if($detail->new_order_process->new_order ->type=='sub')
                                (Sub Order)
                            @endif</td>
                    </tr>
                    <tr>
                        <th class="w-48 p-3 border border-gray-300">Root Domain</th>
                        <td class="p-3 border border-gray-300">{{ $detail->new_site->root_domain }}</td>
                    </tr>
                    @if($detail->new_order_process->new_order->order_type == "niche")
                        <tr>
                            <th class="w-48 p-3 border border-gray-300">Post Urls</th>
                            <td class="p-3 border border-gray-300">{{ $detail->url }}</td>
                        </tr>
                        <tr>
                            <th class="w-48 p-3 border border-gray-300">
                                @if($detail->type == 'replace')
                                    Replace With
                                @else
                                    Insert After
                                @endif
                            </th>
                            <td class="p-3 border border-gray-300">{!! $detail->insert_after !!}</td>
                        </tr>
                        <tr>
                            <th class="w-48 p-3 border border-gray-300">
                                @if($detail->type == 'replace')
                                    Replace Statement
                                @else
                                    Insert Statement
                                @endif
                            </th>
                            <td class="p-3 border border-gray-300">
                                <div id="statement">{!! $detail->statement !!}</div>
                            </td>
                        </tr>
                    @endif
                    @if($detail->new_order_process->new_order->order_type == "gp")
                        <tr>
                            <th class="w-48 p-3 border border-gray-300">Anchor</th>
                            <td class="p-3 border border-gray-300">{{ $detail->anchor }}</td>
                        </tr>
                        <tr>
                            <th class="w-48 p-3 border border-gray-300">Title</th>
                            <td class="p-3 border border-gray-300">{{ $detail->title }}</td>
                        </tr>
                        <tr>
                            <th class="w-48 p-3 border border-gray-300">Doc Urls</th>
                            <td class="p-3 border border-gray-300">{{ $detail->doc_urls }}</td>
                        </tr>
                        <tr>
                            <th class="w-48 p-3 border border-gray-300">Doc File</th>
                            <td class="p-3 border border-gray-300">
                                <a href="{{ url("/uploads/".$detail->upload_doc_file) }}">View File</a>
                                </td>
                        </tr>
                    @else
                        <tr>
                            <th class="w-48 p-3 border border-gray-300">Anchor</th>
                            <td class="p-3 border border-gray-300">{{ $detail->anchor }}</td>
                        </tr>
                        <tr>
                            <th class="w-48 p-3 border border-gray-300">Url</th>
                            <td class="p-3 border border-gray-300">{{ $detail->ourl }}</td>
                        </tr>

                    @endif


                    <tr>
                        <th class="w-48 p-3 border border-gray-300">Note</th>
                        <td class="p-3 border border-gray-300">{{ $detail->note }}</td>
                    </tr>

                    <tr>
                        <th class="w-48 p-3 border border-gray-300">Submit URL</th>
                        <td class="p-3 border border-gray-300">{{ $detail->submit_url }}</td>
                    </tr>


                    </thead>
                </table>
            </div>
        </div>
    @endif


    @if($detail->status == NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER || $detail->status == NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER)
        <div class="bg-white max-w-screen-xl mx-auto mt-4 shadow px-5 p-3 pt-6">




            <div class="bg-yellow-100 mb-4">
                @php
                    $b = Carbon::parse($detail->created_at)->addHours($detail->new_site->total_time);
                @endphp
                <table class="w-full table-auto text-sm border border-separate border-gray-200">
                    <thead>
                    @if($detail->new_site->total_time)
                        @if(Carbon::today()->gt($b))
                            <tr>
                                <th colspan="2" class="p-3 border border-gray-300 bg-red-600 text-white">Your project
                                    time is ticking away! Stay focused and make the most of the time left to complete
                                    your tasks. Don't let the clock run out on your progress!
                                </th>
                            </tr>
                        @else
                            @php
                                $timeDifference = Carbon::now()->diff($b);
                                // Calculate the remaining days, hours, and minutes
                                $remainingDays = $timeDifference->days;
                                $remainingHours = $timeDifference->h;
                                $remainingMinutes = $timeDifference->i;

                                // Create an array to store the time components
                                $timeComponents = [];

                                if ($remainingDays > 0) {
                                    $timeComponents[] = $remainingDays . ($remainingDays === 1 ? ' Day' : ' Days');
                                }
                                if ($remainingHours > 0) {
                                    $timeComponents[] = $remainingHours . ($remainingHours === 1 ? ' Hour' : ' Hours');
                                }
                                if ($remainingMinutes > 0) {
                                    $timeComponents[] = $remainingMinutes . ($remainingMinutes === 1 ? ' Minute' : ' Minutes');
                                }

                                // Combine the time components into the desired format
                                $remainingTime = implode(' : ', $timeComponents);
                            @endphp
                            <tr>
                                <th colspan="2" class="p-3 border border-gray-300 bg-green-600 text-white">
                                    Remaining Time:- {{ $remainingTime }}
                                </th>
                            </tr>
                        @endif
                    @endif
                    <tr>
                        <th class="w-48 p-3 border border-gray-300">Status</th>
                        <td class="p-3 border border-gray-300">
                            @if($detail->status == NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER)
                                <div style="background: blue;color: white;padding:8px;">Pending Order</div>
                            @endif

                            @if($detail->status == NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER)
                                <div style="background: red;color: white;padding:8px;">Rejected by Manager</div>
                            @endif
                        </td>
                    </tr>
                    <tr>
                        <th class="w-48 p-3 border border-gray-300">Order No.</th>
                        <td class="p-3 border border-gray-300">{{ $detail->new_order_process->new_order->order_id }} @if($detail->new_order_process->new_order ->type=='sub')
                                (Sub Order)
                            @endif</td>
                    </tr>
                    <tr>
                        <th class="w-48 p-3 border border-gray-300">Root Domain</th>
                        <td class="p-3 border border-gray-300">{{ $detail->new_site->root_domain }}</td>
                    </tr>
                    @if($detail->new_order_process->new_order->order_type == "niche")
                        <tr>
                            <th class="w-48 p-3 border border-gray-300">Post Urls</th>
                            <td class="p-3 border border-gray-300">{{ $detail->url }}</td>
                        </tr>
                        <tr>
                            <th class="w-48 p-3 border border-gray-300">
                                @if($detail->type == 'replace')
                                    Replace With
                                @else
                                    Insert After
                                @endif
                            </th>
                            <td class="p-3 border border-gray-300">{!! $detail->insert_after !!}</td>
                        </tr>
                        <tr>
                            <th class="w-48 p-3 border border-gray-300">
                                @if($detail->type == 'replace')
                                    Replace Statement
                                @else
                                    Insert Statement
                                @endif
                            </th>
                            <td class="p-3 border border-gray-300">
                                <div id="statement">{!! $detail->statement !!}</div>
                                <button id="copy_btn" class="bg-red-500 text-xs text-white px-3 py-1 rounded">Copy
                                </button>
                            </td>
                        </tr>
                    @endif
                    @if($detail->new_order_process->new_order->order_type == "gp")
                        <tr>
                            <th class="w-48 p-3 border border-gray-300">Anchor</th>
                            <td class="p-3 border border-gray-300">{{ $detail->anchor }}</td>
                        </tr>
                        <tr>
                            <th class="w-48 p-3 border border-gray-300">Title</th>
                            <td class="p-3 border border-gray-300">{{ $detail->title }}</td>
                        </tr>
                        <tr>
                            <th class="w-48 p-3 border border-gray-300">Doc Urls</th>
                            <td class="p-3 border border-gray-300">{{ $detail->doc_urls }}</td>
                        </tr>
                        <tr>
                            <th class="w-48 p-3 border border-gray-300">Doc File</th>
                            <td class="p-3 border border-gray-300">
                                <a href="{{ url("/uploads/".$detail->upload_doc_file) }}">View File</a>
                            </td>
                        </tr>
                    @else
                        <tr>
                            <th class="w-48 p-3 border border-gray-300">Anchor</th>
                            <td class="p-3 border border-gray-300">{{ $detail->anchor }}</td>
                        </tr>
                        <tr>
                            <th class="w-48 p-3 border border-gray-300">Url</th>
                            <td class="p-3 border border-gray-300">{{ $detail->ourl }}</td>
                        </tr>

                    @endif


                    <tr>
                        <th class="w-48 p-3 border border-gray-300">Note</th>
                        <td class="p-3 border border-gray-300">{{ $detail->note }}</td>
                    </tr>
                    <tr>
                        <th colspan="2" class="p-3 border border-gray-300">
                            <form action="{{ route("vendor.post_pending_order",$detail->id) }}" method="POST">
                                @csrf
                                @error("submit_url")
                                    <div>{{ $message }}</div>
                                @enderror

                                <div class="flex items-center space-x-4">
                                    <input type="url" required name="submit_url" class="textbox-class"
                                           placeholder="Enter Submit Url">
                                    <button type="submit" name="submit" value="submit"
                                            class="bg-blue-700 text-white px-4 py-2 rounded">Submit
                                    </button>
                                    {{-- <button type="submit" name="reject" class="bg-red-500 text-white px-4 py-2 rounded">Reject</button>--}}
                                </div>
                            </form>

                            <form action="{{ route("vendor.post_pending_order",$detail->id) }}" method="POST">
                                @csrf
                                <div class="flex items-center space-x-4">
                                    <input type="text" name="reason_for_rejection" class="textbox-class"
                                           placeholder="Reason for Rejection">
                                    <button type="submit" name="reject" value="reject"
                                            class="bg-red-700 text-white px-4 py-2 rounded">Reject
                                    </button>
                                    {{--                                        <button type="submit" name="reject" class="bg-red-500 text-white px-4 py-2 rounded">Reject</button>--}}
                                </div>
                            </form>
                        </th>
                    </tr>

                    </thead>
                </table>
            </div>
        </div>
    @endif

@endsection


@section("footer")
    <script>
        $(function () {
            $('body').on("click", "#copy_btn", function () {
                let text = $(this).siblings("#statement").text();
                window.navigator.clipboard.writeText(text);
                alert("copied");
            });
        });
    </script>
@endsection
