@php use App\Models\Wallet;use Carbon\Carbon;use Illuminate\Support\Facades\Auth; @endphp
@extends("vendor.dashboard.new_design")

@section("heading")
    Edit Profile
@endsection

@section("container")
    <div class="bg-white mt-3 m-3 text-sm shadow">
        <div class="border-b border-gray-300 p-4 text-lg font-bold">User Profile</div>
        <div class="flex items-center justify-between border-b border-gray-300">
            <div class="flex items-start">
                <div class="w-80 flex items-center justify-center mb-6">
                    @if(Auth::user()->profile_image)
                        <img src="/uploads/{{ Auth::user()->profile_image }}"
                             class="w-64 h-64 rounded-full object-cover">
                    @else
                        <img src="/images/user.jpg" class="w-64">
                    @endif
                </div>
                <div class="flex-1 mt-8">
                    <div class="text-3xl font-bold text-black">{{ Auth::user()->name }}</div>
                    <div class="mt-2 text-lg">Blogger</div>

                    <div class="mt-10 text-4xl font-black">
                        {{ vendor_balance() }}</div>
                    <div class="text-lg mt-3">Balance</div>

                </div>
            </div>
            <div class="flex flex-col space-y-4 pr-8">
                <a href="{{ route("vendor.profile") }}"
                   class="bg-[#fc6527] text-white inline-block px-6 py-3 rounded-lg">Update Profile</a>
                <a href="{{ route("change_password") }}"
                   class="bg-[#fc6527] text-white inline-block px-6 py-3 rounded-lg">Change Password</a>
            </div>
        </div>

        <div class="flex items-start py-10">
            <div class="w-80"></div>
            <div class="flex-1 max-w-3xl">
                <div class="flex items-start justify-between mb-3">
                    <div class="font-black">Email Address</div>
                    <div>{{ Auth::user()->email }}</div>
                </div>
                <div class="flex items-start justify-between mb-3">
                    <div class="font-black">Joined On</div>
                    <div>{{ Carbon::parse(Auth::user()->created_at)->toFormattedDateString() }}</div>
                </div>
                <div class="flex items-start justify-between mb-3">
                    <div class="font-black">Country</div>
                    <div>{{ optional(Auth::user()->country)->name }}</div>
                </div>
                <div class="flex items-start justify-between mb-3">
                    <div class="font-black">Whatsapp</div>
                    <div>{{ Auth::user()->whatsapp }}</div>
                </div>
                <div class="flex items-start justify-between mb-3">
                    <div class="font-black">Skype</div>
                    <div>{{ Auth::user()->skype }}</div>
                </div>
                <div class="flex items-start justify-between mb-3">
                    <div class="font-black">Access Role</div>
                    <div>Blogger</div>
                </div>

            </div>

        </div>

    </div>
@stop

