@php use Illuminate\Support\Facades\Auth; @endphp
<div>
    @if(count($histories) > 0)
     <form wire:submit.prevent="withdrawRequest">
         @csrf


        <div class="mb-2">
            <x-flash-messages/>
        </div>

         <table class="table-auto w-full mt-6">
             <thead class="bg-gray-100 ">
             <tr>
                 <th class="text-left py-3 px-4 text-sm"></th>
                 <th class="text-left py-3 px-4 text-sm">Date</th>
                 <th class="text-left py-3 px-4">Order Id</th>
                 <th class="text-left py-3 px-4 text-sm">Amount</th>
             </tr>
             </thead>
             @foreach($histories as $history)
                 <tr class="border-b border-gray-200">
                     <td class="py-3 px-4 text-xs text-left">
                         <input type="checkbox" wire:model="selected_bills" value="{{ $history->id }}">
                     </td>
                     <td class="py-3 px-4 text-xs text-left">{{ $history->created_at->toDayDateTimeString() }}</td>
                     <td class="py-3 px-4 text-xs text-left">
                         <div class="border-b border-gray-300 pb-1 mb-2">
                             {{ optional(optional(optional($history->new_order_process_detail)->new_order_process)->new_order)->order_id }}
                         </div>
                         <div class="flex items-center space-x-2">
                             <span class="font-black">URL:</span>
                             <span>{{ optional($history->new_order_process_detail)->submit_url }}</span>
                         </div>
                     </td>
                     <td class="py-3 px-4 text-left">
                         <div class="flex flex-col">
                             <div>{{ $history->price }}</div>

                         </div>

                     </td>
                 </tr>
             @endforeach
             <tr class="border-b border-gray-200">
                 <td class="py-3 px-4 text-xs text-left"></td>
                 <td class="py-3 px-4 text-xs text-left"></td>
                 <td class="py-3 px-4 text-lg text-left">Total</td>
                 <td class="py-3 px-4 text-lg text-left">{{ $total }}</td>
             </tr>
         </table>

         <div class="flex flex-col mt-4">
             <label for="">Select Payment Method</label>
             <div class="flex items-center space-x-6">
                 @if(in_array("bank",json_decode(Auth::user()->country->payment_methods)))
                     <label class="flex items-center space-x-2">
                         <input type="radio" wire:model="payment_method" value="bank"><span>Bank</span>
                     </label>
                 @endif

                 @if(in_array("paypal",json_decode(Auth::user()->country->payment_methods)))
                     <label class="flex items-center space-x-2">
                         <input type="radio" wire:model="payment_method" value="paypal_id"><span>Paypal ID</span>
                     </label>
                 @endif

                 @if(in_array("qr_code",json_decode(Auth::user()->country->payment_methods)))
                 <label class="flex items-center space-x-2">
                     <input type="radio" wire:model="payment_method" value="qr_code"><span>Qr Code</span>
                 </label>
                 @endif

                 @if(in_array("upi_id",json_decode(Auth::user()->country->payment_methods)))
                 <label class="flex items-center space-x-2">
                     <input type="radio" wire:model="payment_method" value="upi_id"><span>UPI ID</span>
                 </label>
                 @endif
             </div>
             @error("payment_method")
                <div class="text-red-500 text-xs">{{ $message }}</div>
             @enderror
         </div>

         <div class="flex items-center justify-end"><a class="text-blue-600 text-xs font-semibold underline" href="{{ route("vendor.payment_details") }}">Fill Payment Details</a></div>
         @if($payment_method == 'paypal_id')
             <div class="flex flex-col mt-4">
                 <label for="">Paypal Id</label>
                 <div>{{ Auth::user()->paypal_email }}</div>

             </div>


         @endif

         @if($payment_method == 'upi_id')
             <div class="flex flex-col mt-4">
                 <label for="">UPI ID</label>
                 <div>{{ Auth::user()->upi_id }}</div>
             </div>

             <div class="grid grid-cols-3 gap-8">
                 <div class="flex flex-col mt-4">
                     <label for="">Bank Type</label>
                     <input type="text" wire:model.defer="bank_type" disabled class="border border-gray-300">
                     @error("bank_type")
                     <div class="text-red-500 text-xs">{{ $message }}</div>
                     @enderror
                 </div>
                 <div class="flex flex-col mt-4">
                     <label for="">Beneficiary Account Number</label>
                     <input type="text" wire:model.defer="beneficiary_account_number" disabled class="border border-gray-300">
                     @error("beneficiary_account_number")
                     <div class="text-red-500 text-xs">{{ $message }}</div>
                     @enderror
                 </div>
                 <div class="flex flex-col mt-4">
                     <label for="">Beneficiary Name</label>
                     <input type="text" wire:model.defer="beneficiary_name" disabled class="border border-gray-300">
                     @error("beneficiary_name")
                     <div class="text-red-500 text-xs">{{ $message }}</div>
                     @enderror
                 </div>
                 <div class="flex flex-col mt-4">
                     <label for="">Customer Reference Number</label>
                     <input type="text" wire:model.defer="customer_reference_number" disabled class="border border-gray-300">
                     @error("customer_reference_number")
                     <div class="text-red-500 text-xs">{{ $message }}</div>
                     @enderror
                 </div>
                 <div class="flex flex-col mt-4">
                     <label for="">IFSC Code</label>
                     <input type="text" wire:model.defer="ifsc_code" disabled class="border border-gray-300">
                     @error("ifsc_code")
                     <div class="text-red-500 text-xs">{{ $message }}</div>
                     @enderror
                 </div>
                 <div class="flex flex-col mt-4">
                     <label for="">Beneficiary Bank Name</label>
                     <input type="text" wire:model.defer="bene_bank_name" disabled class="border border-gray-300">
                     @error("bene_bank_name")
                     <div class="text-red-500 text-xs">{{ $message }}</div>
                     @enderror
                 </div>
                 <div class="flex flex-col mt-4">
                     <label for="">Beneficiary Bank Branch Name</label>
                     <input type="text" wire:model.defer="bene_bank_branch_name" disabled class="border border-gray-300">
                     @error("bene_bank_branch_name")
                     <div class="text-red-500 text-xs">{{ $message }}</div>
                     @enderror
                 </div>
                 <div class="flex flex-col mt-4">
                     <label for="">Beneficiary Email id</label>
                     <input type="text" wire:model.defer="beneficiary_email_id" disabled class="border border-gray-300">
                     @error("beneficiary_email_id")
                     <div class="text-red-500 text-xs">{{ $message }}</div>
                     @enderror
                 </div>
             </div>


         @endif

         @if($payment_method == 'qr_code')


             <div class="flex flex-col mt-4">
                 <label for="">QR Code</label>
                 @if(Auth::user()->qr_code_image)
                     <img src="/uploads/{{ Auth::user()->qr_code_image }}" class="w-80">
                 @endif

             </div>


         @endif

         @if($payment_method == 'bank')
            <div class="grid grid-cols-3 gap-8">
                <div class="flex flex-col mt-4">
                    <label for="">Bank Type</label>
                    <input type="text" wire:model.defer="bank_type" disabled class="border border-gray-300">
                    @error("bank_type")
                        <div class="text-red-500 text-xs">{{ $message }}</div>
                    @enderror
                </div>
                <div class="flex flex-col mt-4">
                    <label for="">Beneficiary Account Number</label>
                    <input type="text" wire:model.defer="beneficiary_account_number" disabled class="border border-gray-300">
                    @error("beneficiary_account_number")
                    <div class="text-red-500 text-xs">{{ $message }}</div>
                    @enderror
                </div>
                <div class="flex flex-col mt-4">
                    <label for="">Beneficiary Name</label>
                    <input type="text" wire:model.defer="beneficiary_name" disabled class="border border-gray-300">
                    @error("beneficiary_name")
                    <div class="text-red-500 text-xs">{{ $message }}</div>
                    @enderror
                </div>
                <div class="flex flex-col mt-4">
                    <label for="">Customer Reference Number</label>
                    <input type="text" wire:model.defer="customer_reference_number" disabled class="border border-gray-300">
                    @error("customer_reference_number")
                    <div class="text-red-500 text-xs">{{ $message }}</div>
                    @enderror
                </div>
                <div class="flex flex-col mt-4">
                    <label for="">IFSC Code</label>
                    <input type="text" wire:model.defer="ifsc_code" disabled class="border border-gray-300">
                    @error("ifsc_code")
                    <div class="text-red-500 text-xs">{{ $message }}</div>
                    @enderror
                </div>
                <div class="flex flex-col mt-4">
                    <label for="">Beneficiary Bank Name</label>
                    <input type="text" wire:model.defer="bene_bank_name" disabled class="border border-gray-300">
                    @error("bene_bank_name")
                    <div class="text-red-500 text-xs">{{ $message }}</div>
                    @enderror
                </div>
                <div class="flex flex-col mt-4">
                    <label for="">Beneficiary Bank Branch Name</label>
                    <input type="text" wire:model.defer="bene_bank_branch_name" disabled class="border border-gray-300">
                    @error("bene_bank_branch_name")
                    <div class="text-red-500 text-xs">{{ $message }}</div>
                    @enderror
                </div>
                <div class="flex flex-col mt-4">
                    <label for="">Beneficiary Email id</label>
                    <input type="text" wire:model.defer="beneficiary_email_id" disabled class="border border-gray-300">
                    @error("beneficiary_email_id")
                    <div class="text-red-500 text-xs">{{ $message }}</div>
                    @enderror
                </div>
            </div>
         @endif

         <div class="mt-4">
             <button type="submit" class="bg-gray-800 text-sm px-8 py-2 rounded text-white">Send Withdraw Request</button>
         </div>

     </form>
    @else
        <div>No Record Found</div>
    @endif
</div>
