@php use Illuminate\Support\Facades\Auth; @endphp
<div class="bg-white p-4 m-3 border border-gray-200">
    @if(session()->has('success'))
        <div class="bg-green-600 text-white p-3 mb-4">{{ session('success') }}</div>
    @endif
    @if(session()->has('error'))
        <div class="bg-red-600 text-white p-3 mb-4">{{ session('error') }}</div>
    @endif
    <form wire:submit.prevent="savePayment" enctype="multipart/form-data">





        @if(in_array("bank",json_decode(Auth::user()->country->payment_methods)))
            <div class="bg-[#275570] text-white font-black p-3 mb-2">Bank Details</div>
            <div class="grid grid-cols-3 gap-4">
            <div class="flex flex-col mt-4">
                <label class="text-xs font-semibold mb-1">Bank Type</label>
                <input type="text" wire:model.defer="bank_type" class="border border-gray-300">
                @error("bank_type")
                <div class="text-red-500 text-xs">{{ $message }}</div>
                @enderror
            </div>
            <div class="flex flex-col mt-4">
                <label class="text-xs font-semibold mb-1">Beneficiary Account Number</label>
                <input type="text" wire:model.defer="beneficiary_account_number" class="border border-gray-300">
                @error("beneficiary_account_number")
                <div class="text-red-500 text-xs">{{ $message }}</div>
                @enderror
            </div>
            <div class="flex flex-col mt-4">
                <label class="text-xs font-semibold mb-1">Beneficiary Name</label>
                <input type="text" wire:model.defer="beneficiary_name" class="border border-gray-300">
                @error("beneficiary_name")
                <div class="text-red-500 text-xs">{{ $message }}</div>
                @enderror
            </div>
            <div class="flex flex-col mt-4">
                <label class="text-xs font-semibold mb-1">Customer Reference Number</label>
                <input type="text" wire:model.defer="customer_reference_number" class="border border-gray-300">
                @error("customer_reference_number")
                <div class="text-red-500 text-xs">{{ $message }}</div>
                @enderror
            </div>
            <div class="flex flex-col mt-4">
                <label class="text-xs font-semibold mb-1">IFSC Code</label>
                <input type="text" wire:model.defer="ifsc_code" class="border border-gray-300">
                @error("ifsc_code")
                <div class="text-red-500 text-xs">{{ $message }}</div>
                @enderror
            </div>
            <div class="flex flex-col mt-4">
                <label class="text-xs font-semibold mb-1">Beneficiary Bank Name</label>
                <input type="text" wire:model.defer="bene_bank_name" class="border border-gray-300">
                @error("bene_bank_name")
                <div class="text-red-500 text-xs">{{ $message }}</div>
                @enderror
            </div>
            <div class="flex flex-col mt-4">
                <label class="text-xs font-semibold mb-1">Beneficiary Bank Branch Name</label>
                <input type="text" wire:model.defer="bene_bank_branch_name" class="border border-gray-300">
                @error("bene_bank_branch_name")
                <div class="text-red-500 text-xs">{{ $message }}</div>
                @enderror
            </div>
            <div class="flex flex-col mt-4">
                <label class="text-xs font-semibold mb-1">Beneficiary Email id</label>
                <input type="text" wire:model.defer="beneficiary_email_id" class="border border-gray-300">
                @error("beneficiary_email_id")
                <div class="text-red-500 text-xs">{{ $message }}</div>
                @enderror
            </div>
        </div>
        @endif

        @if(in_array("upi_id",json_decode(Auth::user()->country->payment_methods)))
        <div class="bg-[#275570] text-white font-black p-3 mb-2 mt-12">UPI Details</div>
        <div class="grid grid-cols-3 gap-4">
            <div class="flex flex-col mt-4">
                <label class="text-xs font-semibold mb-1">UPI Id</label>
                <input type="text" wire:model.defer="upi_id" class="border border-gray-300">
                @error("upi_id")
                <div class="text-red-500 text-xs">{{ $message }}</div>
                @enderror
            </div>

        </div>
        @endif


        @if(in_array("qr_code",json_decode(Auth::user()->country->payment_methods)))
        <div class="bg-[#275570] text-white font-black p-3 mb-2 mt-12">QR Code</div>
        <div class="grid grid-cols-3 gap-4">

            <div class="flex flex-col mt-4 col-span-2">
               <span class="flex items-center justify-between">
                    <label class="text-xs font-semibold mb-1">Upload QR Code Image</label>
                   @if(Auth::user()->qr_code_image)
                       <span class="text-xs font-bold text-blue-500">
                        <a target="_blank" href="/uploads/{{ Auth::user()->qr_code_image }}">View</a>
                    </span>
                   @endif
               </span>
                <input type="file" wire:model.defer="qr_code_image" class="border border-gray-300 p-1.5">
                @error("qr_code_image")
                <div class="text-red-500 text-xs">{{ $message }}</div>
                @enderror
            </div>
        </div>
        @endif

        @if(in_array("paypal",json_decode(Auth::user()->country->payment_methods)))
        <div class="bg-[#275570] text-white font-black p-3 mb-2 mt-12">Paypal Details</div>
        <div class="grid grid-cols-3 gap-4">
            <div class="flex flex-col mt-4">
                <label class="text-xs font-semibold mb-1">Paypal ID</label>
                <input type="text" wire:model.defer="paypal_id" class="border border-gray-300">
                @error("paypal_id")
                <div class="text-red-500 text-xs">{{ $message }}</div>
                @enderror
            </div>



        </div>
        @endif

        <div class="flex items-center justify-center mt-8">
            <button type="submit" class="bg-black text-white px-8 py-3 rounded">Save</button>
        </div>
    </form>
</div>
