@php use App\Project\NewOrderStatus;use Carbon\Carbon; @endphp
<div>
    <div class="bg-white p-4 shadow">
        <form wire:submit.prevent="searchOrder" class="flex items-end space-x-8">

            <div class="flex flex-col flex-grow">
                <label for="" class="text-xs text-gray-900 font-semibold mb-1">Order Id</label>
                <input type="text" wire:model.defer="order_id" placeholder="Enter Order ID to Search" class="border border-gray-400 leading-5 py-2 rounded">
            </div>

            <div class="flex flex-col flex-grow">
                <label for="" class="text-xs text-gray-900 font-semibold mb-1">Order Typ</label>
                <select wire:model.defer="type" class="border border-gray-400 leading-5 py-2 rounded">
                    <option value="new">New Order</option>
                    <option value="sub">Sub Order</option>
                </select>
            </div>

            <div class="flex-grow">
                <button class="border w-full border-red-500 px-5 py-2 leading-5 rounded text-sm text-red-500">Search For
                    Order
                </button>
            </div>
        </form>
    </div>


    <div class="bg-white p-4 shadow mt-6">
        <div wire:loading.block wire:target="searchOrder" class="flex ">
            <div class="w-full h-64 flex items-center justify-center">
                <div
                    class="loader ease-linear rounded-full border-4 border-t-4 border-t-red-500 border-gray-200 h-24 w-24"></div>
            </div>
        </div>
        @if($order)
            <div>
                <div class="bg-gray-800 text-white p-3 text-xs">Message</div>
                <div class="p-3">
                    {!! $order->message !!}
                </div>
            </div>
            <div class="flex items-start">
                <div class="w-1/3">
                    <table class="w-full table-fixed border-separate">
                        <tr>
                            <th class="border border-gray-300 text-left p-3 text-xs text-red-500">Status</th>
                            <td class="border border-gray-300 text-left p-3 text-xs uppercase font-bold">{{ order_status($order->new_order_status) }}</td>
                        </tr>
                        <tr>
                            <th class="border border-gray-300 text-left p-3 text-xs text-red-500">Order Id</th>
                            <td class="border border-gray-300 text-left p-3 text-xs">{{ $order->order_id }}</td>
                        </tr>
                        <tr>
                            <th class="border border-gray-300 text-left p-3 text-xs text-red-500">Client Name</th>
                            <td class="border border-gray-300 text-left p-3 text-xs">{{ $order->client_name }}</td>
                        </tr>
                        <tr>
                            <th class="border border-gray-300 text-left p-3 text-xs text-red-500">Client Website</th>
                            <td class="border border-gray-300 text-left p-3 text-xs">{{ $order->client_website }}</td>
                        </tr>
                        <tr>
                            <th class="border border-gray-300 text-left p-3 text-xs text-red-500">No of Links</th>
                            <td class="border border-gray-300 text-left p-3 text-xs">{{ $order->no_of_links }}</td>
                        </tr>
                        <tr>
                            <th class="border border-gray-300 text-left p-3 text-xs text-red-500">Order Type</th>
                            <td class="border border-gray-300 text-left p-3 text-xs">{{ $order->order_type }}</td>
                        </tr>
                        <tr>
                            <th class="border border-gray-300 text-left p-3 text-xs text-red-500">Order Package</th>
                            <td class="border border-gray-300 text-left p-3 text-xs">{{ $order->order_package }}</td>
                        </tr>

                    </table>
                </div>
                <div class="w-2/3 ml-4 w-full py-4">
                    <div class="mt-0 flex items-start">
                        <div class="w-24  flex justify-end mr-8 mt-4">
                            <svg xmlns="http://www.w3.org/2000/svg" class="text-slate-800 w-8 h-8"
                                 viewBox="0 0 640 512">
                                <!--! Font Awesome Pro 6.2.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2022 Fonticons, Inc. -->
                                <path
                                    d="M128 120c-13.3 0-24-10.7-24-24s10.7-24 24-24s24 10.7 24 24s-10.7 24-24 24zm32 49.3c28.3-12.3 48-40.5 48-73.3c0-44.2-35.8-80-80-80S48 51.8 48 96c0 32.8 19.7 61 48 73.3V224H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H288v54.7c-28.3 12.3-48 40.5-48 73.3c0 44.2 35.8 80 80 80s80-35.8 80-80c0-32.8-19.7-61-48-73.3V288H608c17.7 0 32-14.3 32-32s-14.3-32-32-32H544V169.3c28.3-12.3 48-40.5 48-73.3c0-44.2-35.8-80-80-80s-80 35.8-80 80c0 32.8 19.7 61 48 73.3V224H160V169.3zM536 96c0 13.3-10.7 24-24 24s-24-10.7-24-24s10.7-24 24-24s24 10.7 24 24zM320 440c-13.3 0-24-10.7-24-24s10.7-24 24-24s24 10.7 24 24s-10.7 24-24 24z"
                                    fill="currentColor"/>
                            </svg>
                        </div>
                        <div class="border border-gray-300 p-4 flex-1">
                            <div class="font-semibold text-red-500 text-sm uppercase">New Order Created</div>
                            <div
                                class="text-xs text-slate-700 mt-1">{{ Carbon::parse($order->created_at)->toDayDateTimeString() }}</div>
                            <div class="text-gray-600 text-xs mt-4">
                                Order Assigned to Team: <span class="uppercase text-slate-800 font-semibold underline">{{ $order->team->name }}
{{--                                    ({{ $order->team->email }})--}}
                                </span>
                            </div>
                        </div>
                    </div>


                    @foreach($order->new_order_processes as $process)
                        <div class="flex items-start w-full mt-8">
                            <div class="w-24  flex justify-end mr-8 mt-4">
                                <svg xmlns="http://www.w3.org/2000/svg" class="text-slate-800 w-8 h-8"
                                     viewBox="0 0 640 512">
                                    <path
                                        d="M128 120c-13.3 0-24-10.7-24-24s10.7-24 24-24s24 10.7 24 24s-10.7 24-24 24zm32 49.3c28.3-12.3 48-40.5 48-73.3c0-44.2-35.8-80-80-80S48 51.8 48 96c0 32.8 19.7 61 48 73.3V224H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H288v54.7c-28.3 12.3-48 40.5-48 73.3c0 44.2 35.8 80 80 80s80-35.8 80-80c0-32.8-19.7-61-48-73.3V288H608c17.7 0 32-14.3 32-32s-14.3-32-32-32H544V169.3c28.3-12.3 48-40.5 48-73.3c0-44.2-35.8-80-80-80s-80 35.8-80 80c0 32.8 19.7 61 48 73.3V224H160V169.3zM536 96c0 13.3-10.7 24-24 24s-24-10.7-24-24s10.7-24 24-24s24 10.7 24 24zM320 440c-13.3 0-24-10.7-24-24s10.7-24 24-24s24 10.7 24 24s-10.7 24-24 24z"
                                        fill="currentColor"/>
                                </svg>
                            </div>
                            <div class="border border-gray-300 p-4 flex-1">

                                <div class="font-semibold text-red-500 text-sm uppercase">
                                    {{ new_order_status($process->status) }}
                                </div>
                                <div class="text-xs text-slate-700 mt-1">{{ $process->created_at }}</div>

                                @if($process->status == NewOrderStatus::$TEAM_PUSHED_TO_MANAGER)
                                    <div class="mt-4">
                                       <table class="table-auto border-separate">
                                           <tr>
                                               <th class="text-xs border border-gray-300 p-3">Root Domain</th>
                                               <th class="text-xs border border-gray-300 p-3">Price</th>
                                               <th class="text-xs border border-gray-300 p-3">Url</th>
                                           </tr>
                                           @foreach($process->new_order_process_details  as $detail)
                                               <tr>
                                                   <td class="text-xs border border-gray-300 p-3">{{ $detail->new_site->root_domain }}</td>
                                                   <td class="text-xs border border-gray-300 p-3">{{ $detail->price }}</td>
                                                   <td class="text-xs border border-gray-300 p-3" >
                                                       {{ $detail->url }}
                                                   </td>
                                               </tr>
                                           @endforeach
                                           <tr>
                                               <td class="text-xs border border-gray-300 p-3">Note</td>
                                               <td colspan="2" class="text-xs border border-gray-300 p-3 break-words">
                                                   {{ $process->note }}
                                               </td>
                                           </tr>
                                       </table>
                                    </div>
                                @endif


                                @if($process->status == NewOrderStatus::$MANAGER_DISAPPROVED_POST_TEAM)
                                    <div class="mt-4">
                                        <table class="table-auto border-separate">
                                            <tr>
                                                <td class="text-xs border border-gray-300 p-3">Note</td>
                                                <td colspan="2" class="text-xs border border-gray-300 p-3 break-words">
                                                    {{ $process->note }}
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                @endif


                                @if( $process->status == NewOrderStatus::$MANAGER_PUSHED_TO_WRITER )
                                    <div class="mt-4">
                                        <div class="flex items-center space-x-3 bg-gray-200 p-3 text-xs font-semibold">
                                            <span>Writer:</span> <span>{{ $process->writer->name }}</span>
                                        </div>
                                        <table class="table-auto border-separate">


                                                @foreach($process->new_order_process_details  as $detail)
                                                <tr>
                                                    <td class="text-xs border border-gray-300 p-3 bg-red-200">Root Domain</td>
                                                    <td class="text-xs border border-gray-300 p-3 bg-red-200">{{ $detail->new_site->root_domain }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="text-xs border border-gray-300 p-3">Url</td>
                                                    <td class="text-xs border border-gray-300 p-3">{{ $detail->ourl }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="text-xs border border-gray-300 p-3">Anchor</td>
                                                    <td class="text-xs border border-gray-300 p-3">{{ $detail->anchor }}</td>
                                                </tr>
                                                @if($order->order_type == "gp")
                                                    <tr>
                                                        <td class="text-xs border border-gray-300 p-3">Title</td>
                                                        <td class="text-xs border border-gray-300 p-3">{{ $detail->title }}</td>
                                                    </tr>
                                                @endif

                                            @endforeach

                                            <tr>
                                                <td class="text-xs border border-gray-300 p-3">Note</td>
                                                <td class="text-xs border border-gray-300 p-3">
                                                    {{ $process->note }}
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                @endif

                                @if( $process->status == NewOrderStatus::$WRITER_PUSHED_TO_MANAGER )
                                    <div class="mt-4">
                                        <table class="table-fixed w-full border-separate">

                                            @foreach($process->new_order_process_details  as $detail)

                                                <tr>
                                                    <td class="text-xs border border-gray-300 p-3 bg-red-200">Root Domain</td>
                                                    <td class="text-xs border border-gray-300 p-3 bg-red-200">{{ $detail->new_site->root_domain }}</td>
                                                </tr>
                                                @if($order->order_type == "gp" )
                                                    <tr>
                                                        <td class="text-xs border border-gray-300 p-3">Upload Doc File</td>
                                                        <td class="text-xs border border-gray-300 p-3">
                                                            @if($detail->upload_doc_file)
                                                                <a href="{{ url("/upload/".$detail->upload_doc_file) }}" class="text-xs font-bold underline text-black">Click to Download</a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="text-xs border border-gray-300 p-3">Doc URLS</td>
                                                        <td class="text-xs border border-gray-300 p-3 "><div class="break-words w-full">{{ $detail->doc_urls }}</div></td>
                                                    </tr>
                                                @endif

                                                @if($order->order_type == "niche" )
                                                    <tr>
                                                        <td class="text-xs border border-gray-300 p-3">Type</td>
                                                        <td class="text-xs border border-gray-300 p-3 "><div class="break-words w-full">{{ $detail->type }}</div></td>
                                                    </tr>
                                                    @if($detail->type == 'insert')
                                                        <tr>
                                                            <td class="text-xs border border-gray-300 p-3">Insert After</td>
                                                            <td class="text-xs border border-gray-300 p-3 "><div class="break-words w-full">{!! $detail->insert_after !!}</div></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="text-xs border border-gray-300 p-3">Insert Statement</td>
                                                            <td class="text-xs border border-gray-300 p-3 "><div class="break-words w-full">{!! $detail->statement !!}</div></td>
                                                        </tr>
                                                    @endif

                                                    @if($detail->type == 'replace')
                                                        <tr>
                                                            <td class="text-xs border border-gray-300 p-3">Replace With</td>
                                                            <td class="text-xs border border-gray-300 p-3 "><div class="break-words w-full">{!! $detail->insert_after !!}</div></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="text-xs border border-gray-300 p-3">Replace Statement</td>
                                                            <td class="text-xs border border-gray-300 p-3 "><div class="break-words w-full">{!! $detail->statement !!}</div></td>
                                                        </tr>
                                                    @endif

                                                @endif
                                                <tr>
                                                    <td class="text-xs border border-gray-300 p-3">Note</td>
                                                    <td class="text-xs border border-gray-300 p-3">{{ $detail->note }}</td>
                                                </tr>

                                            @endforeach

                                        </table>
                                    </div>
                                @endif


                                @if( $process->status == NewOrderStatus::$MANAGER_REJECTED_AND_PUSHED_BACK_TO_WRITER )
                                    <div class="mt-4">
                                        <table class="table-auto border-separate">
                                            <tr>
                                                <td class="text-xs border border-gray-300 p-3">Note</td>
                                                <td class="text-xs border border-gray-300 p-3">
                                                    {{ $process->note }}
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                @endif

                                @if( $process->status == NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER )
                                    <div class="mt-4">
                                        <table class="table-fixed w-full border-separate">

                                            @foreach($process->new_order_process_details  as $detail)
                                                <tr>
                                                    <td class="text-xs border border-gray-300 p-3 bg-red-200">Root Domain</td>
                                                    <td class="text-xs border border-gray-300 p-3 bg-red-200">{{ $detail->new_site->root_domain }}</td>
                                                </tr>

                                                <tr>
                                                    <td class="text-xs border border-gray-300 p-3">Blogger Email</td>
                                                    <td class="text-xs border border-gray-300 p-3">{{ $detail->new_site->uploaded_user->email }}</td>
                                                </tr>
                                                @if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION)
                                                    <tr>
                                                        <td class="text-xs border border-gray-300 p-3 font-bold" style="background: red;color: white;">Blogger Rejected the Order</td>
                                                        <td class="text-xs border border-gray-300 p-3 font-bold" style="background: red;color: white;">{{ Carbon::parse($detail->updated_at)->toDateTimeString() }}</td>
                                                    </tr>
                                                @endif
                                                @if($detail->status == NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS)
                                                    <tr>
                                                        <td class="text-xs border border-gray-300 p-3 font-bold">Blogger Pushed to Manager</td>
                                                        <td class="text-xs border border-gray-300 p-3 font-bold">{{ Carbon::parse($detail->updated_at)->toDateTimeString() }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td class="text-xs border border-gray-300 p-3">Url</td>
                                                        <td class="text-xs border border-gray-300 p-3 break-words">{{ $detail->submit_url }}</td>
                                                    </tr>
                                                @endif

                                                @if($detail->status == NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER)
                                                    <tr>
                                                        <td class="text-xs border border-gray-300 p-3 font-bold">Manager Rejected and Pushed Back to Blogger</td>
                                                        <td class="text-xs border border-gray-300 p-3 font-bold">{{ Carbon::parse($detail->updated_at)->toDateTimeString() }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td class="text-xs border border-gray-300 p-3">Note</td>
                                                        <td class="text-xs border border-gray-300 p-3">{{ $detail->note }}</td>
                                                    </tr>
                                                @endif

                                                @if($detail->status == NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED)
                                                    <tr>
                                                        <td class="text-xs border border-gray-300 p-3 font-bold" style="background: green;color: white">Manager Verified and Complete Order</td>
                                                        <td class="text-xs border border-gray-300 p-3 font-bold" style="background: green;color: white">{{ Carbon::parse($detail->updated_at)->toDateTimeString() }}</td>
                                                    </tr>
                                                    <tr>
                                                        <td class="text-xs border border-gray-300 p-3">Url</td>
                                                        <td class="text-xs border border-gray-300 p-3 break-words">{{ $detail->submit_url }}</td>
                                                    </tr>
                                                @endif

                                                <tr>
                                                    <td></td>
                                                    <td></td>
                                                </tr>

                                            @endforeach

                                        </table>
                                    </div>
                                @endif


                            </div>
                        </div>
                    @endforeach


                </div>
            </div>
        @else
            @if($search == 'searching')
                <div class="h-96 flex items-center justify-center text-3xl font-bold">
                    No Record Found
                </div>
            @endif
        @endif
    </div>

</div>
